/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.SubConsoleLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TestSuiteCollectionConsoleLauncher
extends TestSuiteCollectionLauncher
implements IConsoleLauncher {
    public TestSuiteCollectionConsoleLauncher(TestSuiteCollectionExecutedEntity executedEntity, LauncherManager parentManager, List<ReportableLauncher> subLaunchers, ReportCollectionEntity reportCollection) {
        super(executedEntity, parentManager, subLaunchers, executedEntity.getEntity().getExecutionMode(), reportCollection);
    }

    public static TestSuiteCollectionConsoleLauncher newInstance(TestSuiteCollectionEntity testSuiteCollection, LauncherManager parentManager, Reportable reportable, Rerunable rerunable, Map<String, Object> globalVariables) throws ExecutionException {
        TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(testSuiteCollection);
        executedEntity.setReportable(reportable);
        executedEntity.setRerunable(rerunable);
        try {
            ReportCollectionEntity reportCollection = ReportController.getInstance().newReportCollection(testSuiteCollection.getProject(), testSuiteCollection, executedEntity.getId());
            TestSuiteCollectionConsoleLauncher testSuiteCollectionConsoleLauncher = new TestSuiteCollectionConsoleLauncher(executedEntity, parentManager, TestSuiteCollectionConsoleLauncher.buildSubLaunchers(testSuiteCollection, executedEntity, parentManager, reportCollection, globalVariables), reportCollection);
            ReportController.getInstance().updateReportCollection(reportCollection);
            return testSuiteCollectionConsoleLauncher;
        }
        catch (DALException e) {
            throw new ExecutionException(e);
        }
    }

    private static List<ReportableLauncher> buildSubLaunchers(TestSuiteCollectionEntity testSuiteCollection, TestSuiteCollectionExecutedEntity executedEntity, LauncherManager launcherManager, ReportCollectionEntity reportCollection, Map<String, Object> globalVariables) throws ExecutionException {
        ArrayList<ReportableLauncher> tsLaunchers = new ArrayList<ReportableLauncher>();
        for (TestSuiteRunConfiguration tsRunConfig : testSuiteCollection.getTestSuiteRunConfigurations()) {
            if (!tsRunConfig.isRunEnabled()) continue;
            ConsoleLauncher subLauncher = TestSuiteCollectionConsoleLauncher.buildLauncher(tsRunConfig, launcherManager, reportCollection, globalVariables);
            TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)subLauncher.getRunConfig().getExecutionSetting().getExecutedEntity();
            tsExecutedEntity.setRerunSetting((DefaultRerunSetting)executedEntity.getRunnable());
            tsExecutedEntity.setReportLocation(executedEntity.getReportLocationForChildren(subLauncher.getId()));
            tsExecutedEntity.setEmailConfig(executedEntity.getEmailConfig(testSuiteCollection.getProject()));
            if (tsExecutedEntity.getTotalTestCases() == 0) {
                throw new ExecutionException(ExecutionMessageConstants.LAU_MESSAGE_EMPTY_TEST_SUITE);
            }
            executedEntity.addTestSuiteExecutedEntity(tsExecutedEntity);
            tsLaunchers.add(subLauncher);
        }
        return tsLaunchers;
    }

    private static ConsoleLauncher buildLauncher(TestSuiteRunConfiguration tsRunConfig, LauncherManager launcherManager, ReportCollectionEntity reportCollection, Map<String, Object> globalVariables) throws ExecutionException {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            RunConfigurationDescription configDescription = tsRunConfig.getConfiguration();
            IRunConfiguration runConfig = RunConfigurationCollector.getInstance().getRunConfiguration(configDescription.getRunConfigurationId(), projectDir, configDescription);
            TestSuiteEntity testSuiteEntity = tsRunConfig.getTestSuiteEntity();
            TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(testSuiteEntity);
            executedEntity.prepareTestCases();
            runConfig.setOverridingGlobalVariables(globalVariables);
            runConfig.build((FileEntity)testSuiteEntity, executedEntity);
            SubConsoleLauncher launcher = new SubConsoleLauncher(launcherManager, runConfig, configDescription);
            reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)launcher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)configDescription));
            return launcher;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.LAU_MESSAGE_UNABLE_TO_EXECUTE_TEST_SUITE, tsRunConfig.getTestSuiteEntity().getIdForDisplay()));
        }
    }

    @Override
    public String getStatusMessage(int consoleWidth) {
        return this.getDefaultStatusMessage(consoleWidth) + "\n" + StringUtils.repeat((String)"-", (int)consoleWidth) + "\n" + this.subLauncherManager.getChildrenLauncherStatus(consoleWidth);
    }
}

