/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.katalon.platform.api.execution.TestCaseExecutionContext;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.testdata.reader.CSVReader;
import com.kms.katalon.core.testdata.reader.CSVSeparator;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutionContextImpl;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutionContextImpl;
import com.kms.katalon.execution.entity.TestSuiteExecutionEvent;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.launcher.LoggableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class ReportableLauncher
extends LoggableLauncher {
    private ReportEntity reportEntity;

    public ReportableLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    public abstract ReportableLauncher clone(IRunConfiguration var1);

    @Override
    protected void preExecutionComplete() {
        if (this.getStatus() == LauncherStatus.TERMINATED) {
            return;
        }
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        try {
            this.setStatus(LauncherStatus.PREPARE_REPORT);
            Date startTime = ReportController.getInstance().getDateFromReportFolderName(this.getRunConfig().getExecutionSetting().getName());
            this.updateLastRun(startTime);
            TestSuiteLogRecord suiteLogRecord = this.prepareReport();
            this.uploadReportToIntegratingProduct(suiteLogRecord);
            this.sendReport(suiteLogRecord);
        }
        catch (Exception e) {
            this.writeError(MessageFormat.format(StringConstants.LAU_RPT_ERROR_TO_GENERATE_REPORT, e.getMessage()));
            LogUtil.logError((Throwable)e);
        }
        this.waitForLoggingFinished();
        this.fireTestSuiteExecutionEvent("KATALON_EXECUTION/TEST_SUITE_FINISHED");
        if (this.needToRerun()) {
            Rerunable rerun = (Rerunable)((Object)this.getExecutedEntity());
            TestSuiteEntity testSuite = this.getTestSuite();
            try {
                TestSuiteExecutedEntity newTestSuiteExecutedEntity = ExecutionUtil.getRerunExecutedEntity((TestSuiteExecutedEntity)this.getExecutedEntity(), this.getResult());
                this.writeLine("\n");
                this.writeLine(MessageFormat.format(StringConstants.LAU_RPT_RERUN_TEST_SUITE, this.getExecutedEntity().getSourceId(), String.valueOf(rerun.getPreviousRerunTimes() + 1)));
                IRunConfiguration newConfig = this.getRunConfig().cloneConfig();
                if (this.getRunConfig() instanceof AbstractRunConfiguration && newConfig instanceof AbstractRunConfiguration) {
                    ((AbstractRunConfiguration)newConfig).setExecutionProfile(this.getRunConfig().getExecutionProfile());
                }
                newConfig.build((FileEntity)testSuite, newTestSuiteExecutedEntity);
                ReportableLauncher rerunLauncher = this.clone(newConfig);
                rerunLauncher.getManager().addLauncher(rerunLauncher);
            }
            catch (Exception e) {
                this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_RERUN_TEST_SUITE, ExceptionUtils.getStackTrace((Throwable)e)));
                LogUtil.logError((Throwable)e);
            }
        }
    }

    private boolean needToRerun() {
        if (this.getResult().getNumErrors() + this.getResult().getNumFailures() > 0 && this.getExecutedEntity() instanceof Rerunable) {
            Rerunable rerun = (Rerunable)((Object)this.getExecutedEntity());
            return rerun.getRemainingRerunTimes() > 0;
        }
        return false;
    }

    private void waitForLoggingFinished() {
        try {
            long startTime = System.currentTimeMillis();
            while (!this.loggingFinished && System.currentTimeMillis() - startTime < TimeUnit.MINUTES.toMillis(1L)) {
                Thread.sleep(200L);
            }
        }
        catch (Exception exception) {}
    }

    private void sendReport(TestSuiteLogRecord testSuiteLogRecord) {
        try {
            this.sendReportEmail(testSuiteLogRecord);
        }
        catch (Exception e) {
            this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_EMAIL_REPORT, ExceptionUtils.getStackTrace((Throwable)e)));
            LogUtil.logError((Throwable)e);
        }
    }

    private void sendReportEmail(TestSuiteLogRecord testSuiteLogRecord) throws Exception {
        if (!(this.getExecutedEntity() instanceof TestSuiteExecutedEntity)) {
            return;
        }
        EmailConfig emailConfig = ((TestSuiteExecutedEntity)this.getExecutedEntity()).getEmailConfig(ProjectController.getInstance().getCurrentProject());
        if (emailConfig == null || !emailConfig.canSend()) {
            return;
        }
        if (emailConfig.isSendEmailTestFailedOnly() && testSuiteLogRecord.getStatus() != null && testSuiteLogRecord.getStatus().getStatusValue() != TestStatus.TestStatusValue.FAILED) {
            return;
        }
        this.setStatus(LauncherStatus.SENDING_REPORT, StringConstants.LAU_MESSAGE_SENDING_EMAIL);
        this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_SENDING_EMAIL_RPT_TO, Arrays.toString(emailConfig.getTos())));
        MailUtil.sendSummaryMail(emailConfig, testSuiteLogRecord, new EmailVariableBinding(testSuiteLogRecord));
        this.writeLine(StringConstants.LAU_PRT_EMAIL_SENT);
    }

    protected void updateLastRun(Date startTime) throws Exception {
    }

    protected TestSuiteLogRecord prepareReport() {
        try {
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_GENERATE_REPORT);
            TestSuiteLogRecord suiteLog = ReportUtil.generate((String)this.getRunConfig().getExecutionSetting().getFolderPath());
            File reportFolder = this.getReportFolder();
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_HTML);
            ReportUtil.writeHtmlReport((TestSuiteLogRecord)suiteLog, (File)reportFolder);
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_CSV);
            ReportUtil.writeCSVReport((TestSuiteLogRecord)suiteLog, (File)reportFolder);
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_UUID);
            ReportUtil.writeExecutionUUIDToFile((String)this.getExecutionUUID(), (File)reportFolder);
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_JUNIT);
            ReportUtil.writeJUnitReport((TestSuiteLogRecord)suiteLog, (File)reportFolder);
            this.copyReport();
            return suiteLog;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    protected void copyReport() {
        try {
            ReportLocationSetting reportLocSetting = ((Reportable)((Object)this.getExecutedEntity())).getReportLocationSetting();
            if (reportLocSetting == null || !reportLocSetting.isReportFolderPathSet()) {
                return;
            }
            File userReportFolder = this.getUserReportFolder(reportLocSetting);
            if (userReportFolder != null) {
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_COPYING_RPT_TO_USR_RPT_FOLDER, userReportFolder.getAbsolutePath()));
                if (reportLocSetting.isCleanReportFolderFlagActive()) {
                    this.writeLine(StringConstants.LAU_PRT_CLEANING_USR_RPT_FOLDER);
                    FileUtils.cleanDirectory((File)userReportFolder);
                }
                File[] fileArray = this.getReportFolder().listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File reportChildSourceFile = fileArray[n2];
                    String fileName = FilenameUtils.getBaseName((String)reportChildSourceFile.getName());
                    String fileExtension = FilenameUtils.getExtension((String)reportChildSourceFile.getName());
                    if (!fileExtension.equalsIgnoreCase("lck")) {
                        if (fileExtension.equalsIgnoreCase("csv") || fileExtension.equalsIgnoreCase("html")) {
                            fileName = reportLocSetting.getReportFileName();
                        }
                        if (reportChildSourceFile.isFile()) {
                            FileUtils.copyFile((File)reportChildSourceFile, (File)new File(userReportFolder, String.valueOf(fileName) + "." + fileExtension));
                        } else if (reportChildSourceFile.isDirectory()) {
                            File newCoppiedFolder = new File(userReportFolder, fileName);
                            newCoppiedFolder.mkdirs();
                            FileUtils.copyDirectory((File)reportChildSourceFile, (File)newCoppiedFolder);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    protected void uploadReportToIntegratingProduct(TestSuiteLogRecord suiteLog) {
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            ReportIntegrationContribution contribution = reportContributorEntry.getValue();
            if (contribution == null || !contribution.isIntegrationActive(this.getTestSuite())) continue;
            String integratingProductName = reportContributorEntry.getKey();
            this.setStatus(LauncherStatus.UPLOAD_REPORT, MessageFormat.format(StringConstants.LAU_MESSAGE_UPLOADING_RPT, integratingProductName));
            try {
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_SENDING_RPT_TO, integratingProductName));
                reportContributorEntry.getValue().uploadTestSuiteResult(this.getTestSuite(), suiteLog);
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_REPORT_SENT, integratingProductName));
            }
            catch (Exception e) {
                this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_SEND_INTEGRATION_REPORT, integratingProductName, ExceptionUtils.getStackTrace((Throwable)e)));
                LogUtil.logError((Throwable)e);
            }
        }
    }

    private File getUserReportFolder(ReportLocationSetting rpLocSetting) {
        if (!rpLocSetting.isReportFolderPathSet()) {
            return null;
        }
        File reportFolder = new File(PathUtil.relativeToAbsolutePath((String)rpLocSetting.getReportFolderPath(), (String)this.getTestSuite().getProject().getFolderLocation()));
        if (reportFolder != null && !reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        return reportFolder;
    }

    public TestSuiteEntity getTestSuite() {
        try {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(this.getRunConfig().getExecutionSetting().getExecutedEntity().getSourceId(), ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    protected IExecutedEntity getExecutedEntity() {
        return this.getRunConfig().getExecutionSetting().getExecutedEntity();
    }

    protected File getReportFolder() {
        return new File(this.getRunConfig().getExecutionSetting().getFolderPath());
    }

    protected List<Object[]> collectSummaryData(List<String> csvReports) throws Exception {
        ArrayList<Object[]> newDatas = new ArrayList<Object[]>();
        ArrayList<Object[]> suitesSummaryForEmail = new ArrayList<Object[]>();
        int suiteIndex = 0;
        while (suiteIndex < csvReports.size()) {
            String file = csvReports.get(suiteIndex);
            File csvReportFile = new File(file);
            if (csvReportFile.isFile()) {
                CSVReader csvReader = new CSVReader(file, CSVSeparator.COMMA, true);
                ArrayDeque datas = new ArrayDeque();
                datas.addAll(csvReader.getData());
                List suiteRow = (List)datas.pollFirst();
                String suiteName = String.valueOf(suiteIndex + 1) + "." + (String)suiteRow.get(0);
                String browser = (String)suiteRow.get(1);
                String hostName = this.getRunConfig().getHostConfiguration().getHostName();
                String os = this.getRunConfig().getHostConfiguration().getOS();
                Object[] arrSuitesSummaryForEmail = new Object[]{suiteRow.get(0), 0, 0, 0, 0, hostName, os, browser};
                suitesSummaryForEmail.add(arrSuitesSummaryForEmail);
                int testIndex = 0;
                while (datas.size() > 0) {
                    List row = (List)datas.pollFirst();
                    boolean isEmptyLine = true;
                    for (String col : row) {
                        if (col == null || col.trim().equals("")) continue;
                        isEmptyLine = false;
                        break;
                    }
                    if (!isEmptyLine || datas.isEmpty()) continue;
                    List testRow = (List)datas.pollFirst();
                    String testName = String.valueOf(++testIndex) + "." + (String)testRow.get(0);
                    newDatas.add(ArrayUtils.addAll((Object[])new String[]{suiteName, testName, browser}, (Object[])Arrays.copyOfRange(testRow.toArray(new String[0]), 2, testRow.size())));
                    String testStatus = (String)testRow.get(6);
                    if (TestStatus.TestStatusValue.PASSED.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[1] = (Integer)arrSuitesSummaryForEmail[1] + 1;
                        continue;
                    }
                    if (TestStatus.TestStatusValue.FAILED.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[2] = (Integer)arrSuitesSummaryForEmail[2] + 1;
                        continue;
                    }
                    if (TestStatus.TestStatusValue.ERROR.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[3] = (Integer)arrSuitesSummaryForEmail[3] + 1;
                        continue;
                    }
                    if (!TestStatus.TestStatusValue.INCOMPLETE.toString().equals(testStatus)) continue;
                    arrSuitesSummaryForEmail[4] = (Integer)arrSuitesSummaryForEmail[4] + 1;
                }
            }
            ++suiteIndex;
        }
        File csvSummaryFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "Summary.csv");
        if (csvSummaryFile.exists()) {
            csvSummaryFile.delete();
        }
        CsvWriter.writeArraysToCsv((String[])CsvWriter.SUMMARY_HEADER, newDatas, (File)csvSummaryFile);
        return suitesSummaryForEmail;
    }

    public ReportEntity getReportEntity() {
        try {
            if (this.reportEntity == null) {
                this.reportEntity = ReportController.getInstance().getReportEntity(this.getTestSuite(), this.getId());
            }
            return this.reportEntity;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    @Override
    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
    }

    public void setReportEntity(ReportEntity reportEntity) {
        this.reportEntity = reportEntity;
    }

    protected TestSuiteExecutionEvent fireTestSuiteExecutionEvent(String eventName) {
        IExecutedEntity executedEntity = this.getExecutedEntity();
        if (executedEntity instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity testSuiteEx = (TestSuiteExecutedEntity)executedEntity;
            ArrayList<TestCaseExecutionContext> testCaseContexts = new ArrayList<TestCaseExecutionContext>();
            int iterationIndex = 0;
            int index = 0;
            while (index < testSuiteEx.getExecutedItems().size()) {
                TestCaseExecutedEntity testCaseExecutedEntity = (TestCaseExecutedEntity)testSuiteEx.getExecutedItems().get(index);
                int loopTime = 0;
                while (loopTime < testCaseExecutedEntity.getLoopTimes()) {
                    TestStatus testStatus = this.getResult().getStatuses()[iterationIndex];
                    testCaseContexts.add(TestCaseExecutionContextImpl.Builder.create(testCaseExecutedEntity.getSourceId(), testCaseExecutedEntity.getSourceId()).withTestCaseStatus(testStatus.getStatusValue().name()).withMessage(testStatus.getStackTrace()).build());
                    ++iterationIndex;
                    ++loopTime;
                }
                ++index;
            }
            TestSuiteExecutionContextImpl executionContext = TestSuiteExecutionContextImpl.Builder.create(this.getId(), testSuiteEx.getSourceId()).withReportId(this.getReportEntity().getIdForDisplay()).withTestCaseContext(testCaseContexts).build();
            TestSuiteExecutionEvent eventObject = new TestSuiteExecutionEvent(eventName, executionContext);
            EventBrokerSingleton.getInstance().getEventBroker().post(eventName, (Object)eventObject);
        }
        return null;
    }
}

