/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.configuration.IHostConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.launcher.ProcessLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.LauncherResult;
import com.kms.katalon.execution.logging.ILogCollection;
import com.kms.katalon.execution.logging.LogEvaluator;
import com.kms.katalon.execution.logging.SocketWatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class LoggableLauncher
extends ProcessLauncher
implements ILogCollection,
LogEvaluator {
    private static final int DF_WATCHER_DELAY_TIME = 1;
    private List<XmlLogRecord> logRecords = new ArrayList<XmlLogRecord>();
    private Stack<XmlLogRecord> startRecords = new Stack();
    private int logDepth;
    private LogLevel currentTestCaseResult;
    protected boolean loggingFinished = false;

    public LoggableLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    @Override
    protected void onStartExecution() {
        this.logDepth = 0;
        IHostConfiguration hostConfig = this.getRunConfig().getHostConfiguration();
        this.watchers.add(new SocketWatcher(hostConfig.getHostPort(), 1, this));
        this.currentTestCaseResult = LogLevel.NOT_RUN;
    }

    @Override
    public synchronized void addLogRecords(List<XmlLogRecord> records) {
        LauncherResult launcherResult = (LauncherResult)this.getResult();
        block9: for (XmlLogRecord record : records) {
            this.logRecords.add(record);
            this.onUpdateRecord(record);
            LogLevel logLevel = LogLevel.valueOf((String)record.getLevel().getName());
            if (logLevel == null) continue;
            switch (logLevel) {
                case START: {
                    this.startRecords.push(record);
                    ++this.logDepth;
                    break;
                }
                case END: {
                    if (this.isLogUnderTestCaseMainLevel(this.runConfig, this.logDepth) && this.isStartTestCaseLog(this.startRecords.peek())) {
                        switch (this.currentTestCaseResult) {
                            case PASSED: {
                                launcherResult.increasePasses();
                                break;
                            }
                            case ERROR: {
                                launcherResult.increaseErrors();
                                break;
                            }
                            case FAILED: {
                                launcherResult.increaseFailures();
                                break;
                            }
                        }
                        TestStatus.TestStatusValue statusValue = TestStatus.TestStatusValue.valueOf((String)this.currentTestCaseResult.name());
                        this.onUpdateResult(statusValue);
                        XmlLogRecord testCaseRecord = this.startRecords.peek();
                        String name = (String)testCaseRecord.getProperties().get("name");
                        ExecutionEntityResult result = new ExecutionEntityResult();
                        result.setName(name);
                        result.setTestStatusValue(statusValue);
                        this.notifyProccess((Object)LauncherEvent.UPDATE_RECORD, this.executedEntity, result);
                        this.currentTestCaseResult = LogLevel.NOT_RUN;
                    }
                    --this.logDepth;
                    this.startRecords.pop();
                    if (this.logDepth != 0) continue block9;
                    this.watchdog.stop();
                    this.loggingFinished = true;
                    break;
                }
                default: {
                    if (!LogLevel.getResultLogs().contains(logLevel) || !this.isLogUnderTestCaseMainLevel(this.runConfig, this.logDepth) || !this.isStartTestCaseLog(this.startRecords.peek())) continue block9;
                    this.currentTestCaseResult = logLevel;
                }
            }
        }
    }

    protected void onUpdateRecord(XmlLogRecord record) {
        this.notifyLauncherChanged(LauncherEvent.UPDATE_RECORD, record);
    }

    @Override
    public List<XmlLogRecord> getLogRecords() {
        return this.logRecords;
    }

    protected void clearRecords() {
        this.logRecords.clear();
    }

    @Override
    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
    }

    @Override
    protected void postExecutionComplete() {
        super.postExecutionComplete();
    }
}

