/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.execution.launcher.IWatchdogListener;
import com.kms.katalon.execution.launcher.IWatcher;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import java.util.HashSet;
import java.util.Set;

public class LaunchWatchdog
implements Runnable {
    private ILaunchProcess process;
    private IWatcher[] subWatchdogs;
    private Thread[] subThreads;
    private boolean stopFlag = false;
    private int waitingDelayInMillis;
    private Set<IWatchdogListener> listeners;

    public LaunchWatchdog() {
        this.setWaitingDelayInMillis(10);
    }

    public LaunchWatchdog(int waitingDelayInMillis) {
        this.setWaitingDelayInMillis(waitingDelayInMillis);
    }

    public LaunchWatchdog(IWatcher[] watchers) {
        this.setWaitingDelayInMillis(10);
        this.setSubThreads(watchers);
    }

    public LaunchWatchdog(IWatcher[] watchers, int waitingDelayInMillis) {
        this.setWaitingDelayInMillis(waitingDelayInMillis);
        this.setSubThreads(watchers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.startChildWatchDogs();
            while (true) {
                boolean isProcessTerminated = this.isTerminated();
                if (this.stopFlag && !isProcessTerminated) {
                    this.terminateProcess();
                    isProcessTerminated = true;
                }
                if (isProcessTerminated) {
                    this.terminateChildWatchdogs();
                    return;
                }
                Thread.sleep(this.waitingDelayInMillis);
                continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.notifyProcessTerminated();
        }
    }

    private void startChildWatchDogs() {
        if (this.subWatchdogs == null) {
            return;
        }
        this.subThreads = new Thread[this.subWatchdogs.length];
        int i = 0;
        while (i < this.subWatchdogs.length) {
            this.subThreads[i] = new Thread(this.subWatchdogs[i]);
            this.subThreads[i].start();
            ++i;
        }
    }

    private boolean isTerminated() {
        return this.process != null && this.process.isTerminated();
    }

    private void terminateProcess() {
        if (this.process != null) {
            this.process.terminate();
        }
    }

    public ILaunchProcess getProcess() {
        return this.process;
    }

    public void setProcess(ILaunchProcess process) {
        this.process = process;
    }

    private void terminateChildWatchdogs() {
        if (this.subWatchdogs == null) {
            return;
        }
        IWatcher[] iWatcherArray = this.subWatchdogs;
        int n = this.subWatchdogs.length;
        int n2 = 0;
        while (n2 < n) {
            IWatcher watchdog = iWatcherArray[n2];
            watchdog.stop();
            ++n2;
        }
    }

    public void stop() {
        this.stopFlag = true;
    }

    private void setWaitingDelayInMillis(int waitingDelayInMillis) {
        this.waitingDelayInMillis = waitingDelayInMillis;
    }

    private void setSubThreads(IWatcher[] subThreads) {
        this.subWatchdogs = subThreads;
    }

    private Set<IWatchdogListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<IWatchdogListener>();
        }
        return this.listeners;
    }

    public void addListener(IWatchdogListener listener) {
        this.getListeners().add(listener);
    }

    private void notifyProcessTerminated() {
        for (IWatchdogListener listener : this.getListeners()) {
            listener.onWatchdogComplete(this);
        }
    }
}

