/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ConsoleProcess;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.LaunchProcessor;
import java.io.IOException;
import java.util.List;

public class ConsoleLauncher
extends ReportableLauncher
implements IConsoleLauncher {
    public ConsoleLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    @Override
    public ReportableLauncher clone(IRunConfiguration runConfig) {
        return new ConsoleLauncher(this.getManager(), runConfig);
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            Process systemProcess = this.executeProcess();
            if (systemProcess == null) {
                throw new ExecutionException(ExecutionMessageConstants.CONSOLE_CANNOT_START_EXECUTION);
            }
            return new ConsoleProcess(systemProcess);
        }
        catch (IOException ex) {
            throw new ExecutionException(ex);
        }
    }

    protected Process executeProcess() throws IOException, ExecutionException {
        try {
            return new LaunchProcessor(ClassPathResolver.getClassPaths(ProjectController.getInstance().getCurrentProject()), this.runConfig.getAdditionalEnvironmentVariables()).execute(this.getRunConfig().getExecutionSetting().getScriptFile());
        }
        catch (ControllerException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public synchronized void addLogRecords(List<XmlLogRecord> records) {
        super.addLogRecords(records);
        this.clearRecords();
    }

    @Override
    public String getStatusMessage(int consoleWidth) {
        return this.getDefaultStatusMessage(consoleWidth);
    }

    @Override
    protected void onStartExecution() {
        super.onStartExecution();
    }
}

