/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.generator.TestCaseBindingStringBuilder;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;

public class TestSuiteScriptGenerator {
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.execution.generator.TestSuiteScriptTemplate";
    private static final String GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME = "generateTestSuiteScriptFile";
    private static final String TEMP_TEST_SUITE_FILE_NAME = "TempTestSuite";
    private TestSuiteEntity testSuite;
    private IRunConfiguration config;
    private TestSuiteExecutedEntity testSuiteExecuted;
    private StringBuilder syntaxErrorCollector;

    public TestSuiteScriptGenerator(TestSuiteEntity testSuite, IRunConfiguration config, TestSuiteExecutedEntity testSuiteExecutedEntity) {
        this.testSuite = testSuite;
        this.config = config;
        this.testSuiteExecuted = testSuiteExecutedEntity;
    }

    public File generateScriptFile() throws Exception {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)this.testSuite.getProject());
        File file = new File(libFolder.getRawLocation().toString(), TEMP_TEST_SUITE_FILE_NAME + System.currentTimeMillis() + ".groovy");
        file.createNewFile();
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        object.invokeMethod(GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME, (Object)new Object[]{file, this.testSuite, this.createTestCaseBindings(), this.config, this.testSuiteExecuted});
        libFolder.refreshLocal(1, null);
        return file;
    }

    public String generateScriptAsString() throws Exception {
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        Object[] objectArray = new Object[4];
        objectArray[1] = this.testSuite;
        objectArray[2] = this.createTestCaseBindings();
        objectArray[3] = this.config;
        return (String)object.invokeMethod(GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME, (Object)objectArray);
    }

    public List<String> createTestCaseBindings() {
        ArrayList<String> testCaseBindings = new ArrayList<String>();
        this.syntaxErrorCollector = new StringBuilder();
        List lstTestCaseRun = TestSuiteController.getInstance().getTestSuiteTestCaseRun(this.testSuite);
        for (IExecutedEntity testCaseExecuted : this.testSuiteExecuted.getExecutedItems()) {
            String testCaseId = testCaseExecuted.getSourceId();
            TestSuiteTestCaseLink testCaseLink = null;
            if (this.testSuite instanceof FilteringTestSuiteEntity) {
                testCaseLink = new TestSuiteTestCaseLink();
                testCaseLink.setTestCaseId(testCaseId);
                testCaseLink.setIsRun(true);
            } else {
                testCaseLink = this.getTestCaseLink(testCaseId, lstTestCaseRun);
                lstTestCaseRun.remove(testCaseLink);
            }
            if (testCaseLink == null) {
                throw new IllegalArgumentException("Test case: '" + testCaseId + "' not found");
            }
            List<String> testCaseBinding = this.getTestCaseBindingString(testCaseLink, (TestCaseExecutedEntity)testCaseExecuted);
            testCaseBindings.addAll(testCaseBinding);
        }
        if (this.syntaxErrorCollector.toString().isEmpty()) {
            return testCaseBindings;
        }
        throw new IllegalArgumentException(this.syntaxErrorCollector.toString());
    }

    private TestSuiteTestCaseLink getTestCaseLink(String testCaseId, List<TestSuiteTestCaseLink> distinctTestCaseLink) {
        for (TestSuiteTestCaseLink testCaseLink : distinctTestCaseLink) {
            if (!testCaseLink.getTestCaseId().equals(testCaseId)) continue;
            return testCaseLink;
        }
        return null;
    }

    private List<String> getTestCaseBindingString(TestSuiteTestCaseLink testCaseLink, TestCaseExecutedEntity testCaseExecutedEntity) {
        ArrayList<String> testCaseBindingStrings = new ArrayList<String>();
        int iterationIdx = 0;
        while (iterationIdx < testCaseExecutedEntity.getLoopTimes()) {
            TestCaseBindingStringBuilder builder = new TestCaseBindingStringBuilder(iterationIdx, testCaseExecutedEntity);
            for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                builder.append(variableLink, this.testSuiteExecuted.getTestDataMap());
            }
            if (builder.hasErrors()) {
                this.syntaxErrorCollector.append(builder.getErrorMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                break;
            }
            testCaseBindingStrings.add(builder.build());
            ++iterationIdx;
        }
        return testCaseBindingStrings;
    }
}

