/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.entity.link.TestDataCombinationType;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestDataExecutedEntity;
import com.kms.katalon.execution.exception.SyntaxErrorException;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class TestCaseBindingStringBuilder {
    private int iterationIdx;
    private TestCaseExecutedEntity testCaseExecutedEntity;
    private Map<String, String> variableBinding;
    private StringBuilder syntaxErrorMessage;

    public TestCaseBindingStringBuilder(int iterationIdx, TestCaseExecutedEntity testCaseExecutedEntity) {
        this.iterationIdx = iterationIdx;
        this.testCaseExecutedEntity = testCaseExecutedEntity;
        this.variableBinding = new HashMap<String, String>();
        this.syntaxErrorMessage = new StringBuilder();
    }

    private String getTestCaseBindingName() {
        String testCaseBindingName = this.testCaseExecutedEntity.getSourceId();
        if (this.testCaseExecutedEntity.getLoopTimes() > 1) {
            testCaseBindingName = String.valueOf(testCaseBindingName) + " - Iteration " + Integer.toString(this.iterationIdx + 1);
        }
        return testCaseBindingName;
    }

    private String getDeclarationWithTestCaseName() {
        return "new TestCaseBinding('" + this.getTestCaseBindingName() + "', '" + this.testCaseExecutedEntity.getSourceId() + "', ";
    }

    public String build() {
        if (this.variableBinding.isEmpty()) {
            return String.valueOf(this.getDeclarationWithTestCaseName()) + " null)";
        }
        StringBuilder testCaseBindingString = new StringBuilder(this.getDeclarationWithTestCaseName()).append(" [ ");
        for (Map.Entry<String, String> variableEntry : this.variableBinding.entrySet()) {
            testCaseBindingString.append(variableEntry.getKey()).append(" : ").append(variableEntry.getValue()).append(" , ");
        }
        testCaseBindingString.append(" ])");
        return testCaseBindingString.toString();
    }

    public boolean hasErrors() {
        return this.syntaxErrorMessage.length() > 0;
    }

    public String getErrorMessage() {
        return this.syntaxErrorMessage.toString();
    }

    public void append(VariableLink variableLink, Map<String, TestData> testDataMap) {
        VariableEntity variableEntity = null;
        try {
            variableEntity = TestSuiteController.getInstance().getVariable(this.testCaseExecutedEntity.getSourceId(), variableLink);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (variableEntity == null) {
            return;
        }
        try {
            String variableName = variableEntity.getName();
            String variableValue = this.getVariableValue(variableName, variableLink, testDataMap);
            if (StringUtils.isNotEmpty((String)variableValue)) {
                this.variableBinding.put(GroovyStringUtil.toGroovyStringFormat((String)variableName), variableValue);
            }
        }
        catch (SyntaxErrorException e) {
            this.syntaxErrorMessage.append(e.getMessage()).append(SyntaxUtil.LINE_SEPARATOR);
        }
    }

    private int getRowIndex(TestDataExecutedEntity testDataExecutedEntity) {
        int rowIndex = 0;
        rowIndex = testDataExecutedEntity.getType() == TestDataCombinationType.ONE ? this.iterationIdx % testDataExecutedEntity.getRowIndexes().length : this.iterationIdx / testDataExecutedEntity.getMultiplier() % testDataExecutedEntity.getRowIndexes().length;
        return testDataExecutedEntity.getRowIndexes()[rowIndex];
    }

    private String getVariableValue(String variableName, VariableLink variableLink, Map<String, TestData> testDataMap) throws SyntaxErrorException {
        String variableValue = variableLink.getValue();
        try {
            switch (variableLink.getType()) {
                case DATA_COLUMN: {
                    variableValue = this.getValueByColumnName(variableName, variableLink, testDataMap);
                    break;
                }
                case DATA_COLUMN_INDEX: {
                    variableValue = this.getValueByColumnIndex(variableName, variableLink, testDataMap);
                    break;
                }
                case DEFAULT: {
                    variableValue = null;
                    break;
                }
                case SCRIPT_VARIABLE: {
                    break;
                }
                default: {
                    throw new NotImplementedException(variableLink.getType().name());
                }
            }
            SyntaxUtil.checkVariableSyntax(GroovyStringUtil.toGroovyStringFormat((String)variableName), variableValue);
            return variableValue;
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new SyntaxErrorException(this.getErrorSyntaxMessageWithReason(variableName, variableValue, ex.getMessage()));
        }
    }

    private String getValueByColumnName(String variableName, VariableLink variableLink, Map<String, TestData> testDataMap) throws SyntaxErrorException, IOException {
        return new TestDataValueFinder(this, variableName, variableLink, testDataMap){

            @Override
            protected int getColumnIndex(TestData testData) throws SyntaxErrorException, IOException {
                String columnName = this.variableLink.getValue();
                if (StringUtils.isEmpty((String)columnName)) {
                    throw new SyntaxErrorException(this.getErrorSyntaxMessageWithReason(this.variableName, "", "Column name cannot be empty."));
                }
                return ArrayUtils.indexOf((Object[])testData.getColumnNames(), (Object)columnName) + 1;
            }
        }.getVariableValue();
    }

    private String getValueByColumnIndex(String variableName, VariableLink variableLink, Map<String, TestData> testDataMap) throws IOException, SyntaxErrorException {
        return new TestDataValueFinder(this, variableName, variableLink, testDataMap){

            @Override
            protected int getColumnIndex(TestData testData) throws SyntaxErrorException, IOException {
                String columnIndexAsString = this.variableLink.getValue();
                if (StringUtils.isEmpty((String)columnIndexAsString) || !this.isIntegerFormat(columnIndexAsString)) {
                    throw new SyntaxErrorException(this.getErrorSyntaxMessageWithReason(this.variableName, "", "Variable value is not Integer format."));
                }
                return Integer.valueOf(columnIndexAsString);
            }
        }.getVariableValue();
    }

    private boolean isIntegerFormat(String integerAsString) {
        return StringUtils.isNotEmpty((String)integerAsString) && StringUtils.isNumeric((String)integerAsString);
    }

    private String getErrorSyntaxMessageWithReason(String variableName, String variableValue, String reason) {
        return "Wrong syntax at [Test case ID: " + this.testCaseExecutedEntity.getSourceId() + ", Variable name: " + variableName + ", Variable value: " + this.getDisplayVariableValue(variableValue) + "]. Reason: " + reason;
    }

    private String getDisplayVariableValue(String variableValue) {
        String displayedVariableValue = variableValue;
        if (variableValue == null) {
            displayedVariableValue = "null";
        } else if (variableValue.isEmpty()) {
            displayedVariableValue = "<empty string>";
        }
        return displayedVariableValue;
    }

    private abstract class TestDataValueFinder {
        protected String variableName;
        protected VariableLink variableLink;
        private Map<String, TestData> testDataMap;

        public TestDataValueFinder(String variableName, VariableLink variableLink, Map<String, TestData> testDataMap) {
            this.variableName = variableName;
            this.variableLink = variableLink;
            this.testDataMap = testDataMap;
        }

        protected abstract int getColumnIndex(TestData var1) throws SyntaxErrorException, IOException;

        public String getVariableValue() throws SyntaxErrorException, IOException {
            String testDataLinkId = this.variableLink.getTestDataLinkId();
            if (StringUtils.isEmpty((String)testDataLinkId)) {
                throw new SyntaxErrorException(TestCaseBindingStringBuilder.this.getErrorSyntaxMessageWithReason(this.variableName, this.variableLink.getValue(), "Test data value cannot be empty."));
            }
            TestDataExecutedEntity testDataExecutedEntity = TestCaseBindingStringBuilder.this.testCaseExecutedEntity.getTestDataExecuted(this.variableLink.getTestDataLinkId());
            TestData testData = this.testDataMap.get(testDataExecutedEntity.getTestDataId());
            int rowIndex = TestCaseBindingStringBuilder.this.getRowIndex(testDataExecutedEntity);
            return GroovyStringUtil.toGroovyStringFormat((String)testData.getValue(this.getColumnIndex(testData), rowIndex));
        }
    }
}

