/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.katalon.platform.api.Extension;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.DynamicQueryingTestSuiteDescription;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.core.testdata.TestDataInfo;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestDataCombinationType;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.EmailSettings;
import com.kms.katalon.execution.entity.ExecutedEntity;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestDataExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.exception.ExtensionRequiredException;
import com.kms.katalon.execution.platform.DynamicQueryingTestSuiteExtensionProvider;
import com.kms.katalon.execution.platform.ExecutionPlatformServiceProvider;
import com.kms.katalon.execution.util.MailUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class TestSuiteExecutedEntity
extends ExecutedEntity
implements Reportable,
Rerunable,
ConsoleOptionContributor {
    private List<IExecutedEntity> executedItems;
    private Map<String, TestData> testDataMap = new HashMap<String, TestData>();
    private ReportLocationSetting reportLocationSetting = new ReportLocationSetting();
    private DefaultRerunSetting rerunSetting;
    private EmailSettings emailSettings = new EmailSettings();

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public TestSuiteExecutedEntity() {
        this.rerunSetting = new DefaultRerunSetting();
        this.executedItems = new ArrayList<IExecutedEntity>();
    }

    public TestSuiteExecutedEntity(TestSuiteEntity testSuite) throws Exception {
        this();
        this.setTestSuite(testSuite);
    }

    public TestSuiteExecutedEntity(TestSuiteEntity testSuite, Rerunable rerunnable) throws Exception {
        this(testSuite);
        this.rerunSetting.setPreviousRerunTimes(rerunnable.getPreviousRerunTimes());
        this.rerunSetting.setRemainingRerunTimes(rerunnable.getRemainingRerunTimes());
        this.rerunSetting.setRerunFailedTestCaseOnly(rerunnable.isRerunFailedTestCasesOnly());
    }

    public void setTestSuite(TestSuiteEntity testSuite) throws IOException, Exception {
        this.updateEntity((FileEntity)testSuite);
        this.getEmailConfig(testSuite.getProject()).addRecipients(MailUtil.splitRecipientsString(testSuite.getMailRecipient()));
        this.rerunSetting.setRemainingRerunTimes(testSuite.getNumberOfRerun());
        this.rerunSetting.setRerunFailedTestCaseOnly(testSuite.isRerunFailedTestCasesOnly());
    }

    public void prepareTestCases() throws Exception {
        TestSuiteEntity testSuite = (TestSuiteEntity)this.getEntity();
        List<IExecutedEntity> executedItems = testSuite instanceof FilteringTestSuiteEntity ? this.loadTestCasesForFilteringTestSuite((FilteringTestSuiteEntity)testSuite, "") : this.loadTestCases(testSuite, "");
        this.setTestCaseExecutedEntities(executedItems);
    }

    public void prepareTestCasesWithTestSuiteQuery(String testSuiteQuery) throws Exception {
        TestSuiteEntity testSuite = (TestSuiteEntity)this.getEntity();
        List<IExecutedEntity> executedItems = testSuite instanceof FilteringTestSuiteEntity ? this.loadTestCasesForFilteringTestSuite((FilteringTestSuiteEntity)testSuite, testSuiteQuery) : this.loadTestCases(testSuite, testSuiteQuery);
        this.setTestCaseExecutedEntities(executedItems);
    }

    private List<IExecutedEntity> loadTestCasesForFilteringTestSuite(FilteringTestSuiteEntity testSuite, String testSuiteQuery) throws IOException, ExecutionException, ResourceException {
        ProjectEntity project;
        DynamicQueryingTestSuiteExtensionProvider dynamicQueryingTestSuiteProvider = ExecutionPlatformServiceProvider.getInstance().getPlatformService(DynamicQueryingTestSuiteExtensionProvider.class);
        DynamicQueryingTestSuiteDescription selectedQueryingDescription = dynamicQueryingTestSuiteProvider.getSelectedDynamicQueryingDescription(project = ProjectController.getInstance().getCurrentProject(), testSuite);
        if (selectedQueryingDescription == null) {
            List<Extension> availableExtensions = dynamicQueryingTestSuiteProvider.getAvailableExtensions(project);
            if (availableExtensions.isEmpty()) {
                throw new ExtensionRequiredException("No query provider available to execute the dynamic querying test suite: " + testSuite.getIdForDisplay());
            }
            selectedQueryingDescription = dynamicQueryingTestSuiteProvider.getDynamicQueryingDescription(dynamicQueryingTestSuiteProvider.getSuggestedExtension(project, testSuite));
        }
        List<Object> filteredTestCases = new ArrayList();
        filteredTestCases = dynamicQueryingTestSuiteProvider.getFilteredTestCases(project, testSuite, selectedQueryingDescription, StringUtils.defaultIfEmpty((String)testSuiteQuery, (String)testSuite.getFilteringText()));
        return filteredTestCases.stream().map(tc -> {
            TestCaseExecutedEntity executedTestCase = new TestCaseExecutedEntity((TestCaseEntity)tc);
            executedTestCase.setLoopTimes(1);
            return executedTestCase;
        }).collect(Collectors.toList());
    }

    private List<IExecutedEntity> loadTestCases(TestSuiteEntity testSuite, String testSuiteQuery) throws Exception {
        String projectDir = testSuite.getProject().getFolderLocation();
        this.testDataMap.clear();
        for (TestSuiteTestCaseLink testCaseLink : TestSuiteController.getInstance().getTestSuiteTestCaseRun(testSuite)) {
            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId());
            if (testCase == null) {
                throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TEST_CASE_X_NOT_FOUND, testCaseLink.getTestCaseId()));
            }
            if (!FilterController.getInstance().isMatched((FileEntity)testCase, testSuiteQuery)) continue;
            TestCaseExecutedEntity testCaseExecutedEntity = new TestCaseExecutedEntity(testCase);
            testCaseExecutedEntity.setLoopTimes(1);
            this.prepareTestCaseExecutedEntity(projectDir, testCaseLink, testCaseExecutedEntity);
            this.getExecutedItems().add(testCaseExecutedEntity);
        }
        return this.executedItems;
    }

    private void prepareTestCaseExecutedEntity(String projectDir, TestSuiteTestCaseLink testCaseLink, TestCaseExecutedEntity testCaseExecutedEntity) throws Exception {
        List testDataLinkUsedList = TestSuiteController.getInstance().getTestDataLinkUsedInTestCase(testCaseLink);
        if (testDataLinkUsedList.size() <= 0) {
            return;
        }
        int numberTestCaseUsedOnce = 0;
        int numTestDataRowUsedManyTimes = 1;
        for (TestCaseTestDataLink testDataLink : testDataLinkUsedList) {
            TestData testData = this.findTestData(projectDir, this.testDataMap, testDataLink);
            this.testDataMap.put(testDataLink.getTestDataId(), testData);
            TestDataExecutedEntity testDataExecutedEntity = TestSuiteExecutedEntity.getTestDataExecutedEntity(testCaseLink, testDataLink, testData);
            if (testDataExecutedEntity == null) continue;
            int rowCount = testDataExecutedEntity.getRowIndexes().length;
            if (testDataLink.getCombinationType() == TestDataCombinationType.ONE) {
                numberTestCaseUsedOnce = this.updateNumberTestCaseUsedOnce(numberTestCaseUsedOnce, rowCount);
            } else {
                numTestDataRowUsedManyTimes *= rowCount;
                this.updateMultiplierForSibblingTestDataExecuted(testCaseExecutedEntity, rowCount);
            }
            testCaseExecutedEntity.getTestDataExecutions().add(testDataExecutedEntity);
        }
        testCaseExecutedEntity.setLoopTimes(numTestDataRowUsedManyTimes * Math.max(numberTestCaseUsedOnce, 1));
        TestSuiteExecutedEntity.cutRedundantIndexes(testCaseExecutedEntity, Math.max(numberTestCaseUsedOnce, 1));
    }

    private int updateNumberTestCaseUsedOnce(int numberTestCaseUsedOnce, int rowCount) {
        if (numberTestCaseUsedOnce < 1) {
            return rowCount;
        }
        return Math.min(numberTestCaseUsedOnce, rowCount);
    }

    private void updateMultiplierForSibblingTestDataExecuted(TestCaseExecutedEntity testCaseExecutedEntity, int rowCount) {
        for (TestDataExecutedEntity siblingDataExecuted : testCaseExecutedEntity.getTestDataExecutions()) {
            if (siblingDataExecuted.getType() != TestDataCombinationType.MANY) continue;
            siblingDataExecuted.setMultiplier(siblingDataExecuted.getMultiplier() * rowCount);
        }
    }

    private TestData findTestData(String projectDir, Map<String, TestData> testDataUsedMap, TestCaseTestDataLink testDataLink) throws Exception, IOException {
        TestData testData = testDataUsedMap.get(testDataLink.getTestDataId());
        if (testData == null) {
            testData = TestDataFactory.findTestDataForExternalBundleCaller((String)testDataLink.getTestDataId(), (String)projectDir);
        }
        if (testData == null || testData.getRowNumbers() < 1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_DATA_SRC_X_UNAVAILABLE, testDataLink.getTestDataId()));
        }
        return testData;
    }

    private static void cutRedundantIndexes(TestCaseExecutedEntity testCaseExecutedEntity, int numberTestCaseUsedOnce) {
        if (numberTestCaseUsedOnce <= 1) {
            return;
        }
        for (TestDataExecutedEntity siblingDataExecuted : testCaseExecutedEntity.getTestDataExecutions()) {
            if (siblingDataExecuted.getType() != TestDataCombinationType.ONE || siblingDataExecuted.getRowIndexes().length <= numberTestCaseUsedOnce) continue;
            int[] newRowIndexs = ArrayUtils.remove((int[])siblingDataExecuted.getRowIndexes(), (int)numberTestCaseUsedOnce);
            siblingDataExecuted.setRowIndexes(newRowIndexs);
        }
    }

    private static TestDataExecutedEntity getTestDataExecutedEntity(TestSuiteTestCaseLink testCaseLink, TestCaseTestDataLink testDataLink, TestData testData) throws Exception {
        TestDataExecutedEntity testDataExecutedEntity = new TestDataExecutedEntity(testDataLink.getId(), testDataLink.getTestDataId());
        testDataExecutedEntity.setType(testDataLink.getCombinationType());
        int[] rowIndexes = new int[]{};
        switch (testDataLink.getIterationEntity().getIterationType()) {
            case ALL: {
                rowIndexes = TestSuiteExecutedEntity.getRowIndexesForAllIterationType(testData, testDataLink);
                break;
            }
            case RANGE: {
                rowIndexes = TestSuiteExecutedEntity.getRowIndexesForRangeIterationType(testCaseLink, testDataLink, testData);
                break;
            }
            case SPECIFIC: {
                rowIndexes = TestSuiteExecutedEntity.getRowIndexesForSpecificIterationType(testCaseLink, testDataLink, testData);
            }
        }
        testDataExecutedEntity.setRowIndexes(rowIndexes);
        return testDataExecutedEntity;
    }

    private static int[] getRowIndexesForSpecificIterationType(TestSuiteTestCaseLink testCaseLink, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        String[] rowIndexesString = testDataLink.getIterationEntity().getValue().replace(" ", "").split(",");
        int totalRowCount = testData.getRowNumbers();
        ArrayList<Integer> rowIndexArray = new ArrayList<Integer>();
        int index = 0;
        while (index < rowIndexesString.length) {
            String rowIndexString = rowIndexesString[index];
            if (!rowIndexString.isEmpty()) {
                if (rowIndexString.contains("-")) {
                    String[] rowIndexStartEndString = rowIndexString.split("-");
                    int rowStart = Integer.valueOf(rowIndexStartEndString[0]);
                    int rowEnd = Integer.valueOf(rowIndexStartEndString[1]);
                    if (rowStart > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), testCaseLink.getTestCaseId(), Integer.toString(rowStart)));
                    }
                    if (rowEnd > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), testCaseLink.getTestCaseId(), Integer.toString(rowEnd)));
                    }
                    int rowIndex = rowStart;
                    while (rowIndex <= rowEnd) {
                        rowIndexArray.add(rowIndex);
                        ++rowIndex;
                    }
                } else {
                    int rowIndex = Integer.valueOf(rowIndexString);
                    if (rowIndex < 1 || rowIndex > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_IDX_X_INVALID_TC_Y_TD_Z, rowIndexString, testCaseLink.getTestCaseId(), testDataLink.getTestDataId()));
                    }
                    rowIndexArray.add(rowIndex);
                }
            }
            ++index;
        }
        return ArrayUtils.toPrimitive((Integer[])rowIndexArray.toArray(new Integer[rowIndexArray.size()]));
    }

    private static int[] getRowIndexesForRangeIterationType(TestSuiteTestCaseLink testCaseLink, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        int rowStart = testDataLink.getIterationEntity().getFrom();
        int rowEnd = testDataLink.getIterationEntity().getTo();
        int totalRowCount = testData.getRowNumbers();
        if (rowStart > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, testCaseLink.getTestCaseId(), rowStart));
        }
        if (rowEnd > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, testCaseLink.getTestCaseId(), rowEnd));
        }
        int rowCount = rowEnd - rowStart + 1;
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + rowStart;
            ++index;
        }
        return rowIndexes;
    }

    private static int[] getRowIndexesForAllIterationType(TestData testData, TestCaseTestDataLink testDataLink) throws IOException {
        int rowCount = testData.getRowNumbers();
        if (rowCount <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_DOES_NOT_CONTAIN_ANY_RECORDS, testDataLink.getTestDataId()));
        }
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + 1;
            ++index;
        }
        return rowIndexes;
    }

    @Override
    public List<IExecutedEntity> getExecutedItems() {
        return this.executedItems;
    }

    public void setTestCaseExecutedEntities(List<IExecutedEntity> testCaseExecutedEntities) {
        this.executedItems = testCaseExecutedEntities;
    }

    @Override
    public int getTotalTestCases() {
        int total = 0;
        for (IExecutedEntity testCaseExecutionEntity : this.getExecutedItems()) {
            total += ((TestCaseExecutedEntity)testCaseExecutionEntity).getLoopTimes();
        }
        return total;
    }

    public Map<String, TestData> getTestDataMap() {
        return this.testDataMap;
    }

    public void setTestDataMap(Map<String, TestData> testDataMap) {
        this.testDataMap = testDataMap;
    }

    @Override
    public ReportLocationSetting getReportLocationSetting() {
        return this.reportLocationSetting;
    }

    public void setReportLocation(ReportLocationSetting reportLocation) {
        this.reportLocationSetting = reportLocation;
    }

    @Override
    public int mainTestCaseDepth() {
        return 1;
    }

    @Override
    public boolean isRerunFailedTestCasesOnly() {
        return this.rerunSetting.isRerunFailedTestCasesOnly();
    }

    public DefaultRerunSetting getRerunSetting() {
        return this.rerunSetting;
    }

    public void setRerunSetting(DefaultRerunSetting rerunSetting) {
        this.rerunSetting = rerunSetting;
    }

    @Override
    public int getPreviousRerunTimes() {
        return this.rerunSetting.getPreviousRerunTimes();
    }

    @Override
    public int getRemainingRerunTimes() {
        return this.rerunSetting.getRemainingRerunTimes();
    }

    public void setEmailConfig(EmailConfig emailConfig) {
        this.emailSettings.setEmailConfig(emailConfig);
    }

    @Override
    public EmailConfig getEmailConfig(ProjectEntity project) {
        return this.emailSettings.getEmailConfig(project);
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.addAll(this.reportLocationSetting.getConsoleOptionList());
        consoleOptionList.addAll(this.emailSettings.getConsoleOptionList());
        consoleOptionList.addAll(this.rerunSetting.getConsoleOptionList());
        return consoleOptionList;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        this.reportLocationSetting.setArgumentValue(consoleOption, argumentValue);
        this.emailSettings.setArgumentValue(consoleOption, argumentValue);
        this.rerunSetting.setArgumentValue(consoleOption, argumentValue);
    }

    @Override
    public Map<String, String> getCollectedDataInfo() {
        HashMap<String, String> collectedInfo = new HashMap<String, String>();
        for (TestData testDataUsed : this.testDataMap.values()) {
            TestDataInfo testDataInfo = testDataUsed.getDataInfo();
            if (testDataInfo == null) continue;
            collectedInfo.put(testDataInfo.getKey(), testDataInfo.getInfo());
        }
        return collectedInfo;
    }
}

