/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.IExecutedEntity;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ExecutedEntity
implements IExecutedEntity {
    private String id;
    private FileEntity entity;

    public FileEntity getEntity() {
        return this.entity;
    }

    protected ExecutedEntity() {
        this.entity = null;
    }

    protected ExecutedEntity(FileEntity entity) {
        this.updateEntity(entity);
    }

    protected void updateEntity(FileEntity entity) {
        this.entity = (FileEntity)entity.clone();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        }
        return this.id;
    }

    @Override
    public String getSourceName() {
        return this.entity.getName();
    }

    @Override
    public String getSourceId() {
        return this.entity.getIdForDisplay();
    }

    @Override
    public String getSourceDescription() {
        return this.entity.getDescription();
    }

    @Override
    public String getSourcePath() {
        return this.entity.getLocation();
    }

    @Override
    public Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(StringConstants.ID.toLowerCase(), this.getSourceId());
        attributes.put(StringConstants.NAME.toLowerCase(), this.getSourceName());
        attributes.put(StringConstants.DESCRIPTION.toLowerCase(), this.getSourceDescription());
        return attributes;
    }

    @Override
    public Map<String, String> getCollectedDataInfo() {
        return Collections.emptyMap();
    }
}

