/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console.entity;

import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.ReportableLauncherOptionParser;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteLauncherOptionParser
extends ReportableLauncherOptionParser {
    private static final String EXECUTION_PROFILE_OPTION = "executionProfile";
    private static final String OVERRIDING_GLOBAL_VARIABLE_PREFIX = "g_";
    private List<ConsoleOption<?>> overridingOptions = new ArrayList();
    protected StringConsoleOption testSuitePathOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuitePath";
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    };
    protected StringConsoleOption browserTypeOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "browserType";
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    };
    protected StringConsoleOption executionProfileOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return TestSuiteLauncherOptionParser.EXECUTION_PROFILE_OPTION;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public String getDefaultArgumentValue() {
            return "default";
        }
    };
    private StringConsoleOption katalonStoreApiKeyOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "apiKey";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption installPluginOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "installPlugin";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption testSuiteQuery = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuiteQuery";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        List<ConsoleOption<?>> allOptions = super.getConsoleOptionList();
        allOptions.add(this.testSuitePathOption);
        allOptions.add(this.browserTypeOption);
        allOptions.add(this.executionProfileOption);
        allOptions.add(this.katalonStoreApiKeyOption);
        allOptions.add(this.installPluginOption);
        allOptions.add(this.testSuiteQuery);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null && this.overridingOptions.isEmpty()) {
            this.overridingOptions = new OverridingParametersConsoleOptionContributor(currentProject).getConsoleOptionList();
        }
        allOptions.addAll(this.overridingOptions);
        return allOptions;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        super.setArgumentValue(consoleOption, argumentValue);
        if (consoleOption == this.testSuiteQuery) {
            consoleOption.setValue(argumentValue);
        } else if (consoleOption == this.testSuitePathOption || consoleOption == this.browserTypeOption || consoleOption == this.executionProfileOption || consoleOption == this.installPluginOption || this.overridingOptions.contains(consoleOption)) {
            consoleOption.setValue(argumentValue);
        }
    }

    @Override
    public IConsoleLauncher getConsoleLauncher(ProjectEntity project, LauncherManager manager) throws InvalidConsoleArgumentException, ExecutionException {
        try {
            ExecutionProfileEntity executionProfile;
            TestSuiteEntity testSuite = TestSuiteLauncherOptionParser.getTestSuite(project, (String)this.testSuitePathOption.getValue());
            TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(testSuite);
            executedEntity.setReportLocation(this.reportableSetting.getReportLocationSetting());
            executedEntity.setEmailConfig(this.reportableSetting.getEmailConfig(project));
            executedEntity.setRerunSetting(this.rerunSetting);
            if (this.testSuiteQuery.getValue() == null) {
                executedEntity.prepareTestCases();
            } else {
                executedEntity.prepareTestCasesWithTestSuiteQuery((String)this.testSuiteQuery.getValue());
            }
            AbstractRunConfiguration runConfig = (AbstractRunConfiguration)this.createRunConfiguration(project, testSuite, (String)this.browserTypeOption.getValue());
            String profileName = (String)this.executionProfileOption.getValue();
            if (StringUtils.isBlank((CharSequence)profileName)) {
                profileName = "default";
            }
            if ((executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project)) == null) {
                throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
            }
            runConfig.setExecutionProfile(executionProfile);
            runConfig.setOverridingGlobalVariables(this.getOverridingGlobalVariables());
            runConfig.build((FileEntity)testSuite, executedEntity);
            GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, null);
            return new ConsoleLauncher(manager, runConfig);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Map<String, Object> getOverridingGlobalVariables() {
        HashMap<String, Object> overridingGlobalVariables = new HashMap<String, Object>();
        this.overridingOptions.forEach(a -> {
            if (a.getOption().startsWith(OVERRIDING_GLOBAL_VARIABLE_PREFIX) && a.getValue() != null) {
                overridingGlobalVariables.put(a.getOption().replace(OVERRIDING_GLOBAL_VARIABLE_PREFIX, ""), String.valueOf(a.getValue()));
            }
        });
        return overridingGlobalVariables;
    }

    protected IRunConfiguration createRunConfiguration(ProjectEntity projectEntity, TestSuiteEntity testSuite, String browserType) throws ExecutionException, InvalidConsoleArgumentException {
        IRunConfiguration runConfig = RunConfigurationCollector.getInstance().getRunConfiguration(browserType, projectEntity.getFolderLocation());
        if (runConfig == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_BROWSER_X, browserType));
        }
        return runConfig;
    }

    protected static TestSuiteEntity getTestSuite(ProjectEntity projectEntity, String testSuiteID) throws InvalidConsoleArgumentException {
        try {
            TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteID, projectEntity);
            if (testSuite == null) {
                throw TestSuiteLauncherOptionParser.throwInvalidTestSuiteIdException(testSuiteID);
            }
            return testSuite;
        }
        catch (Exception exception) {
            throw TestSuiteLauncherOptionParser.throwInvalidTestSuiteIdException(testSuiteID);
        }
    }

    private static InvalidConsoleArgumentException throwInvalidTestSuiteIdException(String testSuiteID) {
        return new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_TEST_SUITE_X_NOT_FOUND, testSuiteID));
    }
}

