/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.collector.ConsoleOptionCollector;
import com.kms.katalon.execution.console.ApplicationConfigOptions;
import com.kms.katalon.execution.console.ConsoleExecutor;
import com.kms.katalon.execution.console.LauncherOptionParserFactory;
import com.kms.katalon.execution.console.entity.ConsoleMainOptionContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class ConsoleMain {
    public static final String ARGUMENT_SPLITTER = "=";
    public static final String ARGUMENT_PREFIX = "-";
    public static final String PROPERTIES_FILE_OPTION = "propertiesFile";
    public static final String PROJECT_PK_OPTION = "projectPath";
    public static final String TESTSUITE_ID_OPTION = "testSuitePath";
    public static final String INSTALL_PLUGIN_OPTION = "installPlugin";
    public static final String TESTSUITE_COLLECTION_ID_OPTION = "testSuiteCollectionPath";
    public static final String BROWSER_TYPE_OPTION = "browserType";
    public static final int DEFAULT_SHOW_PROGRESS_DELAY = 15;
    public static final String SHOW_STATUS_DELAY_OPTION = "statusDelay";
    public static final String TESTSUITE_QUERY = "testSuiteQuery";
    public static final String KATALON_STORE_API_KEY_OPTION = "apiKey";

    private ConsoleMain() {
    }

    public static int launch(String[] arguments) {
        ConsoleExecutor consoleExecutor = new ConsoleExecutor();
        ApplicationConfigOptions applicationConfigOptions = new ApplicationConfigOptions();
        OptionParser parser = ConsoleMain.createParser(consoleExecutor, applicationConfigOptions);
        try {
            int exitCode;
            List<String> addedArguments = Arrays.asList(arguments);
            OptionSet options = parser.parse(arguments);
            HashMap<String, String> consoleOptionValueMap = new HashMap<String, String>();
            if (options.has(KATALON_STORE_API_KEY_OPTION)) {
                String apiKeyValue = String.valueOf(options.valueOf(KATALON_STORE_API_KEY_OPTION));
                ConsoleMain.reloadPlugins(apiKeyValue);
                consoleExecutor.addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
                ConsoleMain.acceptConsoleOptionList(parser, consoleExecutor.getAllConsoleOptions());
            }
            if (options.has(INSTALL_PLUGIN_OPTION)) {
                ConsoleMain.installPlugin(String.valueOf(options.valueOf(INSTALL_PLUGIN_OPTION)));
                consoleExecutor.addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
                ConsoleMain.acceptConsoleOptionList(parser, consoleExecutor.getAllConsoleOptions());
            }
            if (options.has(PROPERTIES_FILE_OPTION)) {
                ConsoleMain.readPropertiesFileAndSetToConsoleOptionValueMap(String.valueOf(options.valueOf(PROPERTIES_FILE_OPTION)), consoleOptionValueMap);
                addedArguments = ConsoleMain.buildArgumentsForPropertiesFile(arguments, consoleOptionValueMap);
            }
            for (ConsoleOption<?> opt : applicationConfigOptions.getConsoleOptionList()) {
                String optionName = opt.getOption();
                if (!options.hasArgument(optionName)) continue;
                applicationConfigOptions.setArgumentValue(opt, String.valueOf(options.valueOf(optionName)));
            }
            ProjectEntity project = ConsoleMain.findProject(options);
            ConsoleMain.setDefaultExecutionPropertiesOfProject(project, consoleOptionValueMap);
            ConsoleMain.acceptConsoleOptionList(parser, new OverridingParametersConsoleOptionContributor(project).getConsoleOptionList());
            options = parser.parse(addedArguments.toArray(new String[addedArguments.size()]));
            consoleExecutor.execute(project, options);
            ConsoleMain.waitForExecutionToFinish(options);
            List<ILauncher> consoleLaunchers = LauncherManager.getInstance().getSortedLaunchers();
            int n = exitCode = consoleLaunchers.get(consoleLaunchers.size() - 1).getResult().getReturnCode();
            return n;
        }
        catch (InvalidConsoleArgumentException e) {
            LogUtil.printErrorLine((String)e.getMessage());
            return 4;
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)ExceptionUtils.getStackTrace((Throwable)e));
            return 2;
        }
        finally {
            LauncherManager.getInstance().removeAllTerminated();
        }
    }

    private static void reloadPlugins(String apiKey) throws Exception {
        Bundle katalonBundle = Platform.getBundle((String)"com.kms.katalon");
        Class reloadPluginsHandlerClass = katalonBundle.loadClass("com.kms.katalon.composer.handlers.ConsoleModeReloadPluginsHandler");
        Object handler = reloadPluginsHandlerClass.newInstance();
        Method reloadMethod = Arrays.asList(reloadPluginsHandlerClass.getMethods()).stream().filter(method -> method.getName().equals("reload")).findAny().orElse(null);
        if (reloadMethod != null) {
            reloadMethod.invoke(handler, apiKey);
        }
    }

    private static void installPlugin(String filePath) throws InterruptedException, BundleException {
        BundleContext context = Platform.getBundle((String)"com.katalon.platform").getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(PluginInstaller.class);
        PluginInstaller pluginInstaller = (PluginInstaller)context.getService(serviceReference);
        if (!filePath.equals("")) {
            pluginInstaller.installPlugin(context, new File(filePath).toURI().toString());
        }
    }

    private static List<String> buildArgumentsForPropertiesFile(String[] arguments, Map<String, String> consoleOptionValueMap) {
        ArrayList<String> addedArguments = new ArrayList<String>(Arrays.asList(arguments));
        consoleOptionValueMap.forEach((key, value) -> addedArguments.add(ARGUMENT_PREFIX + key + ARGUMENT_SPLITTER + value));
        return addedArguments;
    }

    private static OptionParser createParser(ConsoleExecutor executor, ApplicationConfigOptions applicationConfigOptions) {
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts(PROPERTIES_FILE_OPTION).withRequiredArg().ofType(String.class);
        ConsoleMain.acceptConsoleOptionList(parser, new ConsoleMainOptionContributor().getConsoleOptionList());
        ConsoleMain.acceptConsoleOptionList(parser, executor.getAllConsoleOptions());
        OptionSpecBuilder configSpec = parser.accepts(applicationConfigOptions.getConfigOption());
        applicationConfigOptions.getConsoleOptionList().stream().forEach(consoleOption -> {
            OptionSpecBuilder optionSpecBuilder2 = parser.accepts(consoleOption.getOption()).availableIf((OptionSpec)configSpec, new OptionSpec[0]);
            if (consoleOption.hasArgument()) {
                optionSpecBuilder2.withRequiredArg().ofType(consoleOption.getArgumentType());
            }
        });
        return parser;
    }

    private static ProjectEntity findProject(OptionSet options) throws Exception {
        String projectPath = null;
        if (options.has(PROJECT_PK_OPTION)) {
            projectPath = String.valueOf(options.valueOf(PROJECT_PK_OPTION));
        } else if (options.has(PROPERTIES_FILE_OPTION)) {
            projectPath = ConsoleMain.readPropertyFileAndGetProperty(String.valueOf(options.valueOf(PROPERTIES_FILE_OPTION)), PROJECT_PK_OPTION);
        }
        if (projectPath == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, PROJECT_PK_OPTION));
        }
        return ConsoleMain.getProject(projectPath);
    }

    private static void setDefaultExecutionPropertiesOfProject(ProjectEntity project, Map<String, String> consoleOptionValueMap) throws IOException, InvalidConsoleArgumentException {
        ConsoleOptionCollector.getInstance().writeDefaultPropertyFile(project);
        ConsoleMain.readPropertiesFileAndSetToConsoleOptionValueMap(String.valueOf(project.getFolderLocation()) + File.separator + "console.properties", consoleOptionValueMap);
    }

    private static void readPropertiesFileAndSetToConsoleOptionValueMap(String fileLocation, Map<String, String> consoleOptionValueMap) throws IOException, InvalidConsoleArgumentException {
        if (!ConsoleMain.validateFileLocation(fileLocation)) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(ExecutionMessageConstants.MNG_PRT_INVALID_PROPERTY_FILE_ARG, fileLocation));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(fileLocation);){
            Properties prop = new Properties();
            prop.load(input);
            for (Map.Entry<Object, Object> propertyEntry : prop.entrySet()) {
                consoleOptionValueMap.put(String.valueOf(propertyEntry.getKey()), String.valueOf(propertyEntry.getValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String readPropertyFileAndGetProperty(String fileLocation, String propertyName) throws IOException {
        if (ConsoleMain.validateFileLocation(fileLocation)) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(fileLocation);){
            Properties prop = new Properties();
            prop.load(input);
            return prop.getProperty(propertyName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean validateFileLocation(String fileLocation) {
        return StringUtils.isNotBlank((String)fileLocation) && new File(fileLocation).exists();
    }

    private static void acceptConsoleOptionList(OptionParser parser, List<ConsoleOption<?>> consoleOptionList) {
        for (ConsoleOption<?> consoleOption : consoleOptionList) {
            OptionSpecBuilder optionSpecBuilder = parser.accepts(consoleOption.getOption());
            if (!consoleOption.hasArgument()) continue;
            optionSpecBuilder.withRequiredArg().ofType(consoleOption.getArgumentType());
        }
    }

    private static void waitForExecutionToFinish(OptionSet options) {
        int progressDelay = 15;
        if (options.has(SHOW_STATUS_DELAY_OPTION)) {
            String progressDelayString = String.valueOf(options.valueOf(SHOW_STATUS_DELAY_OPTION));
            try {
                progressDelay = Integer.valueOf(progressDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_PARSE_X_FOR_Y_TO_INTEGER, progressDelayString, SHOW_STATUS_DELAY_OPTION));
            }
        }
        ConsoleMain.waitForExecutionToFinish(progressDelay);
    }

    private static void waitForExecutionToFinish(int showProgressDelay) {
        int progressDelayTimeInMiliseconds = (showProgressDelay < 0 ? 15 : showProgressDelay) * 1000;
        do {
            ConsoleMain.printStatus();
            try {
                Thread.sleep(progressDelayTimeInMiliseconds);
            }
            catch (InterruptedException interruptedException) {}
        } while (LauncherManager.getInstance().isAnyLauncherRunning());
        ConsoleMain.printStatus();
    }

    private static void printStatus() {
        int consoleWidth = 80;
        LogUtil.printOutputLine((String)LauncherManager.getInstance().getStatus(consoleWidth));
    }

    private static ProjectEntity getProject(String projectPk) throws Exception {
        File projectFile = new File(projectPk);
        if (projectFile.isDirectory()) {
            LogUtil.printOutputLine((String)StringConstants.MNG_PRT_PROJECT_PATH_IS_FOLDER);
            File[] projectFiles = projectFile.listFiles();
            if (projectFiles != null) {
                File[] fileArray = projectFiles;
                int n = projectFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PR_EXAMINE_FILE, file.getName()));
                    } else {
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PR_EXAMINE_FOLDER, file.getName()));
                    }
                    if (file.isFile() && file.getName().endsWith(ProjectEntity.getProjectFileExtension())) {
                        projectPk = file.getAbsolutePath();
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PRT_FOUND_PROJECT_FILE, projectPk));
                    }
                    ++n2;
                }
            }
        }
        ConsoleMain.deleteLibFolders(projectPk);
        ProjectEntity projectEntity = ProjectController.getInstance().openProject(projectPk);
        EventBrokerSingleton.getInstance().getEventBroker().post("PROJECT/OPENED", null);
        if (projectEntity == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_FIND_PROJ_X, projectPk));
        }
        return projectEntity;
    }

    private static void deleteLibFolders(String projectPk) {
        try {
            File projectFolder;
            File projectFile = new File(projectPk);
            if (projectFile.isFile() && projectFile.exists() && (projectFolder = projectFile.getParentFile()).exists()) {
                ConsoleMain.deleteLibFolder(projectFolder, "bin");
                ConsoleMain.deleteLibFolder(projectFolder, "Libs");
            }
        }
        catch (Throwable t) {
            LogUtil.printAndLogError((Throwable)t, (String)"Unable to delete lib folders");
        }
    }

    private static void deleteLibFolder(File projectFolder, String libFolderName) {
        File libFolder = new File(projectFolder, libFolderName);
        if (libFolder.exists()) {
            LogUtil.printOutputLine((String)("Delete folder: " + libFolderName));
            try {
                FileUtils.forceDelete((File)libFolder);
            }
            catch (IOException e) {
                LogUtil.printAndLogError((Throwable)e, (String)("Unable to delete folder: " + libFolderName));
            }
        }
    }
}

