/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.collector.ConsoleOptionCollector;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteCollectionLauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteLauncherOptionParser;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;

public class ConsoleExecutor {
    private List<LauncherOptionParser> launcherOptions = new ArrayList<LauncherOptionParser>();
    private List<ConsoleOptionContributor> optionalOptions;

    public ConsoleExecutor() {
        this.launcherOptions.addAll(Arrays.asList(new TestSuiteLauncherOptionParser(), new TestSuiteCollectionLauncherOptionParser()));
        this.optionalOptions = ConsoleOptionCollector.getInstance().getOptionContributors();
    }

    public void addAndPrioritizeLauncherOptionParser(List<LauncherOptionParser> consoleOptionParser) {
        this.launcherOptions.addAll(0, consoleOptionParser);
    }

    public List<ConsoleOption<?>> getAllConsoleOptions() {
        ArrayList consoleOptions = new ArrayList();
        consoleOptions.addAll(this.getConsoleOptionInContributors(this.launcherOptions));
        consoleOptions.addAll(this.getConsoleOptionInContributors(this.optionalOptions));
        return consoleOptions;
    }

    private List<ConsoleOption<?>> getConsoleOptionInContributors(List<? extends ConsoleOptionContributor> contributors) {
        ArrayList consoleOptions = new ArrayList();
        for (ConsoleOptionContributor consoleOptionContributor : contributors) {
            consoleOptions.addAll(consoleOptionContributor.getConsoleOptionList());
        }
        return consoleOptions;
    }

    public void execute(ProjectEntity projectEntity, OptionSet optionSet) throws Exception {
        this.setValueForOptionalOptions(this.optionalOptions, optionSet);
        LauncherOptionParser launcherOption = new LauncherOptionSelector().getSelectedOption(optionSet);
        List<ConsoleOption<?>> listConsoleOption = launcherOption.getConsoleOptionList();
        for (ConsoleOption<?> consoleOption : listConsoleOption) {
            String option = consoleOption.getOption();
            if (!optionSet.has(option)) continue;
            launcherOption.setArgumentValue(consoleOption, String.valueOf(optionSet.valueOf(consoleOption.getOption())));
        }
        LauncherManager launcherManager = LauncherManager.getInstance();
        launcherManager.addLauncher(launcherOption.getConsoleLauncher(projectEntity, launcherManager));
        this.trackExecution(launcherOption);
    }

    private void trackExecution(LauncherOptionParser launcherOption) {
        if (launcherOption instanceof TestSuiteLauncherOptionParser) {
            String[] browserType = new String[]{""};
            ((TestSuiteLauncherOptionParser)launcherOption).getConsoleOptionList().stream().filter(option -> option.getOption().equals("browserType")).findFirst().ifPresent(option -> {
                String string = (String)option.getValue();
            });
            Trackings.trackExecuteTestSuiteInConsoleMode((!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)browserType[0]);
        } else if (launcherOption instanceof TestSuiteCollectionLauncherOptionParser) {
            Trackings.trackExecuteTestSuiteCollectionInConsoleMode((!ActivationInfoCollector.isActivated() ? 1 : 0) != 0);
        }
    }

    private void setValueForOptionalOptions(List<ConsoleOptionContributor> optionContributors, OptionSet optionSet) throws Exception {
        for (ConsoleOptionContributor contributor : optionContributors) {
            for (ConsoleOption<?> consoleOption : contributor.getConsoleOptionList()) {
                this.validateRequiredArgument(consoleOption, optionSet);
                String optionName = consoleOption.getOption();
                if (!optionSet.has(optionName) || !consoleOption.hasArgument()) continue;
                contributor.setArgumentValue(consoleOption, String.valueOf(optionSet.valueOf(optionName)));
            }
        }
    }

    private void validateRequiredArgument(ConsoleOption<?> consoleOption, OptionSet optionSet) throws InvalidConsoleArgumentException {
        if (consoleOption.isRequired() && !optionSet.has(consoleOption.getOption())) {
            String optionName = consoleOption.getOption();
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, optionName));
        }
    }

    private class LauncherOptionSelector {
        private LauncherOptionSelector() {
        }

        public LauncherOptionParser getSelectedOption(OptionSet optionSet) throws InvalidConsoleArgumentException {
            for (LauncherOptionParser launcherOption : ConsoleExecutor.this.launcherOptions) {
                if (!this.evaluate(launcherOption, optionSet)) continue;
                return launcherOption;
            }
            throw this.buildMissingLauncherArgumentException();
        }

        private InvalidConsoleArgumentException buildMissingLauncherArgumentException() {
            Iterator iterator = ConsoleExecutor.this.launcherOptions.iterator();
            StringBuilder messageBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                LauncherOptionParser launcherOption = (LauncherOptionParser)iterator.next();
                if (StringUtils.isNotEmpty((String)messageBuilder.toString())) {
                    messageBuilder.append(" or ");
                }
                messageBuilder.append(this.getRequiredOptionsString(launcherOption));
            }
            return new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, messageBuilder.toString()));
        }

        private String getRequiredOptionsString(LauncherOptionParser launcherOption) {
            String requiredOptions = launcherOption.getConsoleOptionList().stream().filter(option -> option.isRequired()).map(option -> "-" + option.getOption()).collect(Collectors.joining(", "));
            return "{" + requiredOptions + "}";
        }

        private boolean evaluate(LauncherOptionParser optionParser, OptionSet optionSet) throws InvalidConsoleArgumentException {
            Iterator<ConsoleOption<?>> iterator = optionParser.getConsoleOptionList().iterator();
            boolean anyRequiesExisted = false;
            while (iterator.hasNext()) {
                ConsoleOption<?> consoleOption = iterator.next();
                if (!consoleOption.isRequired()) continue;
                if (optionSet.has(consoleOption.getOption())) {
                    anyRequiesExisted = true;
                    continue;
                }
                if (anyRequiesExisted) {
                    throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, consoleOption.getOption()));
                }
                return false;
            }
            return anyRequiesExisted;
        }
    }
}

