/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.kms.katalon.execution.collector.DriverConnectorCollector;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class CustomRunConfiguration
extends AbstractRunConfiguration {
    private String name;
    private Map<String, IDriverConnector> driverConnectors;
    private File configFolder;
    protected String projectDir;

    public CustomRunConfiguration(String projectDir, String name) throws IOException, ExecutionException {
        this.name = name;
        this.projectDir = projectDir;
        this.initConfigFolder(projectDir);
    }

    private void initConfigFolder(String projectFolderLocation) throws IOException, ExecutionException {
        this.setConfigFolder(this.getConfigFolder(projectFolderLocation));
        this.initDriverConnectors();
    }

    @Override
    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new CustomRunConfiguration(this.projectDir, this.name);
    }

    private void initDriverConnectors() throws IOException, ExecutionException {
        this.driverConnectors = new LinkedHashMap<String, IDriverConnector>();
        if (this.configFolder == null || !this.configFolder.exists()) {
            return;
        }
        this.driverConnectors = DriverConnectorCollector.getInstance().getDriverConnectors(this.getConfigFolder());
    }

    private File getConfigFolder(String projectFolderLocation) {
        return new File(String.valueOf(projectFolderLocation) + File.separator + RunConfigurationCollector.CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH + File.separator + this.name);
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        return this.driverConnectors;
    }

    public void clearAllDriverConnectors() {
        this.driverConnectors.clear();
    }

    public void addDriverConnector(String contributorName, IDriverConnector driverConnector) {
        if (driverConnector == null) {
            return;
        }
        this.driverConnectors.put(contributorName, driverConnector);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws IOException, ExecutionException {
        this.name = name;
        this.configFolder = this.getConfigFolder(this.getProjectFolderLocation());
        for (IDriverConnector driverConnector : this.driverConnectors.values()) {
            driverConnector.setParentFolderPath(this.configFolder.getAbsolutePath());
        }
    }

    public void save() throws IOException {
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
        for (IDriverConnector driverConnector : this.driverConnectors.values()) {
            driverConnector.saveUserConfigProperties();
        }
    }

    public void delete() throws IOException {
        if (this.configFolder.exists()) {
            FileUtils.deleteDirectory((File)this.configFolder);
        }
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public void setConfigFolder(File configFolder) {
        this.configFolder = configFolder;
    }

    public String toString() {
        StringBuilder valueString = new StringBuilder();
        boolean isFirst = true;
        for (IDriverConnector driverConnector : this.getDriverConnectors().values()) {
            if (!isFirst) {
                valueString.append(" + ");
            } else {
                isFirst = false;
            }
            valueString.append(String.valueOf(driverConnector.getDriverType().toString()) + ": " + driverConnector.toString());
        }
        return valueString.toString();
    }
}

