/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.google.gson.Gson;
import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.LogbackUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.IHostConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.configuration.impl.LocalHostConfiguration;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.generator.FeatureFileScriptGenerator;
import com.kms.katalon.execution.generator.TestCaseScriptGenerator;
import com.kms.katalon.execution.generator.TestSuiteScriptGenerator;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.util.ExecutionUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class AbstractRunConfiguration
implements IRunConfiguration {
    protected IHostConfiguration hostConfiguration;
    protected DefaultExecutionSetting executionSetting;
    private ExecutionProfileEntity executionProfile;
    private Map<String, Object> overridingParameters = new HashMap<String, Object>();

    public AbstractRunConfiguration() {
        this.initExecutionSetting();
    }

    @Override
    public final IExecutionSetting build(FileEntity fileEntity, IExecutedEntity executedEntity) throws IOException, ExecutionException {
        this.init(fileEntity);
        this.executionSetting.setExecutedEntity(executedEntity);
        this.hostConfiguration = new LocalHostConfiguration();
        this.generateLogFolder(fileEntity);
        this.generateExecutionProperties();
        File scriptFile = this.generateTempScriptFile(fileEntity);
        this.executionSetting.setScriptFile(scriptFile);
        return this.executionSetting;
    }

    protected File generateTempScriptFile(FileEntity fileEntity) throws ExecutionException {
        try {
            if (fileEntity instanceof TestSuiteEntity) {
                return new TestSuiteScriptGenerator((TestSuiteEntity)fileEntity, this, (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity()).generateScriptFile();
            }
            if (fileEntity instanceof TestCaseEntity) {
                return new TestCaseScriptGenerator((TestCaseEntity)fileEntity, this).generateScriptFile();
            }
            if (fileEntity instanceof SystemFileEntity) {
                return new FeatureFileScriptGenerator((SystemFileEntity)fileEntity, this).generateScriptFile();
            }
            throw new ExecutionException("The execution is not supported for this file");
        }
        catch (Exception ex) {
            throw new ExecutionException(ex.getMessage());
        }
    }

    protected void init(FileEntity fileEntity) throws IOException {
        if (fileEntity == null) {
            return;
        }
        int timeOut = fileEntity instanceof TestSuiteEntity && !((TestSuiteEntity)fileEntity).isPageLoadTimeoutDefault() ? (int)((TestSuiteEntity)fileEntity).getPageLoadTimeout().shortValue() : ExecutionUtil.getDefaultImplicitTimeout();
        this.executionSetting.setTimeout(timeOut);
    }

    protected void initExecutionSetting() {
        this.executionSetting = new DefaultExecutionSetting();
    }

    protected String getTemporaryLogFolderLocation(FileEntity testCase) {
        try {
            return ReportController.getInstance().generateTemporaryExecutionFolder(testCase);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String getLogFolderLocation(TestSuiteEntity testSuite) {
        try {
            return ReportController.getInstance().generateReportFolder(testSuite);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void generateLogFolder(FileEntity fileEntity) {
        String logFolderPath = "";
        if (fileEntity instanceof TestCaseEntity || fileEntity instanceof SystemFileEntity) {
            logFolderPath = this.getTemporaryLogFolderLocation(fileEntity);
        } else if (fileEntity instanceof TestSuiteEntity) {
            logFolderPath = this.getLogFolderLocation((TestSuiteEntity)fileEntity);
        }
        this.executionSetting.setFolderPath(logFolderPath);
    }

    @Override
    public String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation().replace(File.separator, "/");
    }

    @Override
    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put(StringConstants.NAME, this.getName());
        propertyMap.put("projectDir", this.getProjectFolderLocation());
        propertyMap.put("host", this.hostConfiguration.getProperties());
        if (this.executionSetting == null) {
            return propertyMap;
        }
        propertyMap.putAll(ExecutionUtil.getExecutionProperties(this.executionSetting, this.getDriverConnectors(), this.executionProfile));
        IExecutedEntity executedEntity = this.executionSetting.getExecutedEntity();
        if (executedEntity == null) {
            return propertyMap;
        }
        if (!this.overridingParameters.isEmpty()) {
            propertyMap.put("overridingGlobalVariables", this.overridingParameters);
        }
        propertyMap.put("id", executedEntity.getSourceId());
        propertyMap.put("name", executedEntity.getSourceName());
        propertyMap.put("description", executedEntity.getSourceDescription());
        propertyMap.put("source", executedEntity.getSourcePath());
        ExecutionSessionSocketServer sessionServer = ExecutionSessionSocketServer.getInstance();
        propertyMap.put("sessionServer.host", sessionServer.getServerHost());
        propertyMap.put("sessionServer.port", sessionServer.getServerPort());
        String logbackConfigFileLocation = this.getLogbackConfigFileLocation();
        if (logbackConfigFileLocation != null) {
            propertyMap.put("logbackConfigFileLocation", logbackConfigFileLocation);
        }
        propertyMap.put("runningMode", ApplicationRunningMode.get().name());
        this.initializePluginPresence("com.katalon.katalon-studio-smart-xpath", propertyMap);
        return propertyMap;
    }

    private boolean initializePluginPresence(String pluginID, Map<String, Object> propertyMap) {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin(pluginID);
        if (plugin != null) {
            propertyMap.put(pluginID, true);
            return true;
        }
        return false;
    }

    private String getLogbackConfigFileLocation() {
        String logbackConfigFileLocation = null;
        try {
            File logbackConfigFile = LogbackUtil.getLogbackConfigFile();
            if (logbackConfigFile != null && logbackConfigFile.exists()) {
                logbackConfigFileLocation = logbackConfigFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {}
        return logbackConfigFileLocation;
    }

    @Override
    public String getName() {
        StringBuilder nameStringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (IDriverConnector driverConnector : this.getDriverConnectors().values()) {
            if (!isFirst) {
                nameStringBuilder.append(" + ");
            }
            nameStringBuilder.append(driverConnector.getDriverType().toString());
            isFirst = false;
        }
        return nameStringBuilder.toString();
    }

    @Override
    public IHostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    @Override
    public IExecutionSetting getExecutionSetting() {
        return this.executionSetting;
    }

    @Override
    public final void generateExecutionProperties() throws IOException {
        File settingFile = new File(this.executionSetting.getSettingFilePath());
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(this.getProperties());
        FileUtils.writeStringToFile((File)settingFile, (String)strJson);
    }

    @Override
    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        return new HashMap<String, String>();
    }

    @Override
    public boolean allowsRecording() {
        return false;
    }

    @Override
    public ExecutionProfileEntity getExecutionProfile() {
        return this.executionProfile;
    }

    public void setExecutionProfile(ExecutionProfileEntity executionProfile) {
        this.executionProfile = executionProfile;
    }

    @Override
    public void setOverridingGlobalVariables(Map<String, Object> overridingGlobalVariables) {
        if (overridingGlobalVariables == null) {
            return;
        }
        this.overridingParameters.putAll(overridingGlobalVariables);
    }
}

