/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.execution.configuration.IDriverConnector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class AbstractDriverConnector
implements IDriverConnector {
    protected File propertyConfigFile;
    protected Map<String, Object> driverProperties;
    protected String parentFolderPath;

    public AbstractDriverConnector(String configurationFolderPath) throws IOException {
        this.parentFolderPath = configurationFolderPath;
        this.propertyConfigFile = new File(String.valueOf(configurationFolderPath) + File.separator + this.getSettingFileName() + ".properties");
        this.loadDriverProperties();
    }

    @Override
    public void setParentFolderPath(String parentFolderPath) {
        this.parentFolderPath = parentFolderPath;
        this.propertyConfigFile = new File(String.valueOf(parentFolderPath) + File.separator + this.getSettingFileName() + ".properties");
    }

    @Override
    public String getParentFolderPath() {
        return this.parentFolderPath;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put(this.getDriverType().getPropertyKey(), this.getDriverType().getPropertyValue());
        return systemProperties;
    }

    protected void loadDriverProperties() throws IOException {
        if (this.propertyConfigFile.exists()) {
            Map<String, Map<String, Object>> allProperties = this.getAllDriverProperties();
            if (allProperties.get(this.getDriverType().getName()) == null) {
                this.driverProperties = new LinkedHashMap<String, Object>();
                return;
            }
            this.driverProperties = allProperties.get(this.getDriverType().getName());
        } else {
            this.driverProperties = new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public Map<String, Object> getUserConfigProperties() {
        return this.driverProperties;
    }

    @Override
    public void setUserConfigProperties(Map<String, Object> properties) {
        this.driverProperties = properties;
    }

    @Override
    public void saveUserConfigProperties() throws IOException {
        if (!this.propertyConfigFile.exists()) {
            this.propertyConfigFile.createNewFile();
        }
        Map<String, Map<String, Object>> driverPropertiesMap = this.getAllDriverProperties();
        driverPropertiesMap.put(this.getDriverType().getName(), this.driverProperties);
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(driverPropertiesMap);
        FileUtils.writeStringToFile((File)this.propertyConfigFile, (String)strJson);
    }

    protected Map<String, Map<String, Object>> getAllDriverProperties() throws IOException {
        if (this.propertyConfigFile.exists()) {
            Gson gsonObj = new Gson();
            try {
                String propertyConfigFileContent = FileUtils.readFileToString((File)this.propertyConfigFile);
                Type collectionType = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
                Map result = (Map)gsonObj.fromJson(propertyConfigFileContent, collectionType);
                if (result == null) {
                    return new LinkedHashMap<String, Map<String, Object>>();
                }
                for (Map.Entry entry : result.entrySet()) {
                    this.convertSettingValue((Map)entry.getValue());
                }
                return result;
            }
            catch (JsonSyntaxException | IOException throwable) {}
        }
        return new HashMap<String, Map<String, Object>>();
    }

    public void convertSettingValue(List<Object> list) {
        int i = 0;
        while (i < list.size()) {
            Object object = list.get(i);
            if (object instanceof List) {
                this.convertSettingValue((List)object);
            } else if (object instanceof Map) {
                this.convertSettingValue((Map)object);
            } else if (object instanceof Double) {
                list.set(i, (double)((Double)object));
            }
            ++i;
        }
    }

    public void convertSettingValue(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof List) {
                this.convertSettingValue((List)object);
                continue;
            }
            if (object instanceof Map) {
                this.convertSettingValue((Map)object);
                continue;
            }
            if (!(object instanceof Double)) continue;
            entry.setValue((double)((Double)object));
        }
    }

    @Override
    public Object getDriverPropertyValue(String rawKey) {
        for (Map.Entry<String, Object> driverProperty : this.getUserConfigProperties().entrySet()) {
            if (!driverProperty.getKey().equals(rawKey)) continue;
            return driverProperty.getValue();
        }
        return null;
    }

    @Override
    public void setDriverPropertyValue(String rawKey, String propertyValue) {
        for (Map.Entry<String, Object> driverProperty : this.getUserConfigProperties().entrySet()) {
            if (!driverProperty.getKey().equals(rawKey)) continue;
            driverProperty.setValue(propertyValue);
        }
    }

    public String toString() {
        return this.getUserConfigProperties().toString();
    }

    public abstract IDriverConnector clone();

    protected Object cloneDriverPropertyValue(Object propertyValue) {
        if (propertyValue instanceof String) {
            return new String((String)propertyValue);
        }
        if (propertyValue instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object object : (List)propertyValue) {
                newList.add(this.cloneDriverPropertyValue(object));
            }
            return newList;
        }
        if (propertyValue instanceof Map) {
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((Map)propertyValue).entrySet()) {
                newMap.put(this.cloneDriverPropertyValue(entry.getKey()), this.cloneDriverPropertyValue(entry.getValue()));
            }
            return newMap;
        }
        return propertyValue;
    }
}

