/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.classpath;

import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.execution.classpath.BuildPathEntry;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.classpath.IBuildPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class BundleBuildPath
implements IBuildPath {
    private List<IBuildPath> buildPaths;
    private Bundle bundle;

    public BundleBuildPath(Bundle bundle) {
        this.setBundle(bundle);
    }

    @Override
    public String getBuildPathLocation() throws IOException {
        File bundleFile = new File(ClassPathResolver.getBundleLocation(this.bundle));
        if (bundleFile.isFile()) {
            return bundleFile.getAbsolutePath();
        }
        return new File(bundleFile, "bin").getAbsolutePath();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    private void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public static boolean isCoreBundle(Bundle bundle) {
        for (IKeywordContributor contributor : KeywordContributorCollection.getKeywordContributors()) {
            Bundle coreBundle = FrameworkUtil.getBundle((Class)contributor.getKeywordClass());
            if (bundle.getBundleId() != coreBundle.getBundleId()) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidEntry(Bundle bundle) throws IOException {
        String bundleName;
        File bundleFile = new File(ClassPathResolver.getBundleLocation(bundle));
        String string = bundleName = bundleFile.isDirectory() ? bundleFile.getName() : FilenameUtils.getBaseName((String)bundleFile.getName());
        if (bundleName.contains("_") && StringUtils.isBlank((String)(bundleName = bundleName.split("_")[0]))) {
            return false;
        }
        if (bundleName.startsWith("org.eclipse.core") || bundleName.startsWith("com.kms.katalon.core") || "org.codehaus.groovy".equalsIgnoreCase(bundleName)) {
            return false;
        }
        return !BundleBuildPath.isCoreBundle(bundle);
    }

    public List<IBuildPath> getChildBuildPaths() throws IOException {
        if (this.buildPaths == null) {
            this.buildPaths = new ArrayList<IBuildPath>();
            this.buildPaths.addAll(this.getRequiredBuildPaths());
            this.buildPaths.addAll(this.getResourceBuildPaths());
        }
        return this.buildPaths;
    }

    private List<IBuildPath> getResourceBuildPaths() throws IOException {
        try {
            File bundleFile = new File(ClassPathResolver.getBundleLocation(this.bundle));
            if (bundleFile.isFile()) {
                return Collections.emptyList();
            }
            ArrayList<IBuildPath> resourceBuildPaths = new ArrayList<IBuildPath>();
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)this.bundle.getHeaders().get("Bundle-ClassPath")));
            if (elements == null) {
                return Collections.emptyList();
            }
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement manifestElement = manifestElementArray[n2];
                String[] stringArray = manifestElement.getValueComponents();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File libFile;
                    String lib = stringArray[n4];
                    if (!".".equals(manifestElement.getValue()) && (libFile = new File(bundleFile, lib)).exists()) {
                        resourceBuildPaths.add(new BuildPathEntry(libFile.getAbsolutePath()));
                    }
                    ++n4;
                }
                ++n2;
            }
            return resourceBuildPaths;
        }
        catch (BundleException bundleException) {
            return Collections.emptyList();
        }
    }

    private List<IBuildPath> getRequiredBuildPaths() throws IOException {
        try {
            ArrayList<IBuildPath> requiredBuildPaths = new ArrayList<IBuildPath>();
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)this.bundle.getHeaders().get("Require-Bundle")));
            if (elements == null) {
                return Collections.emptyList();
            }
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement manifestElement = manifestElementArray[n2];
                Bundle requiredBundle = Platform.getBundle((String)manifestElement.getValue());
                if (BundleBuildPath.isValidEntry(requiredBundle)) {
                    File bundleFile = new File(ClassPathResolver.getBundleLocation(requiredBundle));
                    if (bundleFile.isDirectory()) {
                        BundleBuildPath bundleBuildPath = new BundleBuildPath(requiredBundle);
                        requiredBuildPaths.add(bundleBuildPath);
                        requiredBuildPaths.addAll(bundleBuildPath.getChildBuildPaths());
                    } else {
                        requiredBuildPaths.add(new BuildPathEntry(ClassPathResolver.getBundleLocation(requiredBundle)));
                    }
                }
                ++n2;
            }
            return requiredBuildPaths;
        }
        catch (BundleException bundleException) {
            return Collections.emptyList();
        }
    }
}

