/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.handler;

import com.kms.katalon.composer.components.impl.tree.TestListenerFolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testlistener.dialog.NewTestListenerDialog;
import com.kms.katalon.composer.testlistener.handler.OpenTestListenerHandler;
import com.kms.katalon.composer.testlistener.handler.TestListenerTreeRootCatcher;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestListenerController;
import com.kms.katalon.entity.file.TestListenerEntity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatGroovyAction;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewTestListenerHandler
extends TestListenerTreeRootCatcher {
    private static final List<String> sampleMethodNames = Arrays.asList("com.kms.katalon.core.annotation.BeforeTestCase", "com.kms.katalon.core.annotation.AfterTestCase", "com.kms.katalon.core.annotation.BeforeTestSuite", "com.kms.katalon.core.annotation.AfterTestSuite");
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IEventBroker eventBroker;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        TestListenerFolderTreeEntity parentTreeFolder = this.getParentTestListenerTreeFolder(this.selectionService, true);
        if (parentTreeFolder == null) {
            return;
        }
        try {
            TestListenerController testListenerController = TestListenerController.getInstance();
            NewTestListenerDialog dialog = new NewTestListenerDialog(parentShell, testListenerController.getTestListeners(parentTreeFolder.getObject()));
            if (dialog.open() != 0) {
                return;
            }
            NewTestListenerDialog.NewTestListenerResult result = dialog.getResult();
            TestListenerEntity entity = testListenerController.newTestListener(result.getNewName(), parentTreeFolder.getObject());
            FileUtils.write((File)new File(entity.getLocation()), (CharSequence)new TestListenerScriptBuilder(result).buildTestListenerScript(), (String)"UTF-8", (boolean)true);
            OpenTestListenerHandler openHandler = new OpenTestListenerHandler();
            ITextEditor editor = openHandler.openEditor(entity);
            if (editor != null) {
                this.formatEditor(editor);
            }
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeFolder);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void formatEditor(ITextEditor editor) {
        FormatGroovyAction formatAction = (FormatGroovyAction)editor.getAction("Format");
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        formatAction.run((ITextSelection)new TextSelection(0, document.getLength()));
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    private class TestListenerScriptBuilder {
        private final NewTestListenerDialog.NewTestListenerResult result;

        public TestListenerScriptBuilder(NewTestListenerDialog.NewTestListenerResult result) {
            this.result = result;
        }

        private String getSampleScript(String annotation) {
            switch (annotation) {
                case "com.kms.katalon.core.annotation.BeforeTestCase": {
                    return this.getFileContent("resources/template/before_test_case.tpl");
                }
                case "com.kms.katalon.core.annotation.AfterTestCase": {
                    return this.getFileContent("resources/template/after_test_case.tpl");
                }
                case "com.kms.katalon.core.annotation.BeforeTestSuite": {
                    return this.getFileContent("resources/template/before_test_suite.tpl");
                }
                case "com.kms.katalon.core.annotation.AfterTestSuite": {
                    return this.getFileContent("resources/template/after_test_suite.tpl");
                }
            }
            return "";
        }

        private String buildListSampleMethods() {
            List sampleStrings = this.result.getSampleMethodAllowed().entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (String)e.getKey()).sorted(new Comparator<String>(){

                @Override
                public int compare(String methodA, String methodB) {
                    return sampleMethodNames.indexOf(methodA) - sampleMethodNames.indexOf(methodB);
                }
            }).map(m -> this.getSampleScript((String)m)).collect(Collectors.toList());
            return StringUtils.join(sampleStrings, (String)"\n\n");
        }

        public String buildTestListenerScript() {
            String newTestListenerScript = this.getFileContent("resources/template/new_test_listener.tpl");
            StringBuilder scriptBuilder = new StringBuilder(newTestListenerScript).append("\n\n").append(String.format("class %s {\n %s \n}", this.result.getNewName(), this.buildListSampleMethods()));
            return scriptBuilder.toString();
        }

        private String getFileContent(String filePath) {
            URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(NewTestListenerHandler.class), (IPath)new Path(filePath), null);
            try {
                return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
                return "";
            }
        }
    }
}

