/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.handler;

import com.kms.katalon.composer.components.impl.tree.TestListenerTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.composer.testlistener.constant.ComposerTestListenerMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestListenerController;
import com.kms.katalon.entity.file.TestListenerEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DeleteTestListenerHandler
implements IDeleteEntityHandler {
    public Class<? extends ITreeEntity> entityType() {
        return TestListenerTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        if (!(treeEntity instanceof TestListenerTreeEntity)) {
            return false;
        }
        TestListenerEntity testListener = null;
        try {
            testListener = (TestListenerEntity)treeEntity.getObject();
        }
        catch (Exception exception) {}
        monitor.subTask(MessageFormat.format(ComposerTestListenerMessageConstants.HAND_JOB_DELETING, testListener.getIdForDisplay()));
        try {
            IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).getFile(Path.fromOSString((String)testListener.getRelativePath()));
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            TestListenerController.getInstance().deleteTestListener(testListener);
            return true;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

