/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.dialog;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.testlistener.constant.ComposerTestListenerMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.file.TestListenerEntity;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameTestListenerDialog
extends TitleAreaDialog {
    private Text txtName;
    private List<TestListenerEntity> siblingListeners;
    private String newName;
    private TestListenerEntity currentListener;

    public RenameTestListenerDialog(Shell parentShell, TestListenerEntity listenerEntity, List<TestListenerEntity> siblingListeners) {
        super(parentShell);
        this.siblingListeners = siblingListeners;
        this.currentListener = listenerEntity;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite nameComposite = new Composite(container, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        nameComposite.setLayout((Layout)layout);
        Label lblName = new Label(nameComposite, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(nameComposite, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 200;
        this.txtName.setLayoutData((Object)gdTxtName);
        this.setInput();
        this.registerControlModifyListeners();
        parent.pack();
        return container;
    }

    private void setInput() {
        this.txtName.setText(this.currentListener.getName());
        this.txtName.selectAll();
        this.txtName.forceFocus();
        this.setMessage(ComposerTestListenerMessageConstants.DIA_TITLE_RENAME_TEST_LISTENER, 1);
    }

    private boolean isNameDupplicated(String newName) {
        return this.siblingListeners.parallelStream().filter(l -> l.getName().equals(newName)).findAny().isPresent();
    }

    private void checkNewName(String newName) {
        if (this.isNameDupplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        IStatus status = JavaConventionsUtil.validateJavaTypeName((String)this.txtName.getText(), null);
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(ComposerTestListenerMessageConstants.DIA_TITLE_RENAME_TEST_LISTENER, 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setMessage(status.getMessage(), 3);
            }
        }
        this.getButton(0).setEnabled(status.getSeverity() != 4);
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameTestListenerDialog.this.checkNewName(RenameTestListenerDialog.this.txtName.getText());
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerTestListenerMessageConstants.DIA_TITLE_RENAME_TEST_LISTENER);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected void okPressed() {
        this.newName = this.txtName.getText();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(400, 200);
    }

    public String getNewName() {
        return this.newName;
    }
}

