/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.wizard;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.wizard.AbstractWizardPage;
import com.kms.katalon.composer.components.impl.wizard.IWizardPage;
import com.kms.katalon.composer.components.impl.wizard.IWizardPageChangedListerner;
import com.kms.katalon.composer.components.impl.wizard.WizardManager;
import com.kms.katalon.composer.components.impl.wizard.WizardPageChangedEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SimpleWizardDialog
extends Dialog
implements IWizardPageChangedListerner {
    private static final int BUTTON_WIDTH = 80;
    public static final int BACK_BUTTON_ID = 0;
    public static final int NEXT_BUTTON_ID = 1;
    public static final int FINISH_BUTTON_ID = 2;
    public static final int CANCEL_BUTTON_ID = 3;
    protected Composite stepDetailsComposite;
    protected Map<Integer, Button> buttonMap;
    protected WizardManager wizardManager;
    protected HashMap<String, Object> sharedData;

    public SimpleWizardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected String getDialogTitle() {
        return "";
    }

    protected Control createDialogArea(Composite parent) {
        return this.createWizardArea(parent);
    }

    protected final Control createButtonBar(Composite parent) {
        return null;
    }

    protected final Control oldDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    protected Control createWizardArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setLayout((Layout)new FillLayout());
        this.createDialogContainer(mainComposite);
        return mainComposite;
    }

    protected Composite createDialogContainer(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        GridLayout glMainArea = new GridLayout(1, false);
        glMainArea.marginHeight = 0;
        glMainArea.marginWidth = 0;
        mainArea.setLayout((Layout)glMainArea);
        Composite stepAreaComposite = this.createStepAreaComposite(mainArea);
        stepAreaComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite separatorAndButtonComposite = new Composite(mainArea, 0);
        GridLayout glSeparatorAndButtonComposite = new GridLayout();
        glSeparatorAndButtonComposite.marginWidth = 0;
        glSeparatorAndButtonComposite.marginHeight = 0;
        separatorAndButtonComposite.setLayout((Layout)glSeparatorAndButtonComposite);
        separatorAndButtonComposite.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        this.createSeparator(separatorAndButtonComposite);
        Composite buttonBarComposite = this.createButtonBarComposite(separatorAndButtonComposite);
        buttonBarComposite.setLayoutData((Object)new GridData(131072, 1024, true, false, 1, 1));
        return mainArea;
    }

    protected Composite createStepAreaComposite(Composite mainComposite) {
        Composite stepAreaComposite = new Composite(mainComposite, 0);
        stepAreaComposite.setLayout((Layout)new FillLayout());
        this.stepDetailsComposite = new Composite(stepAreaComposite, 0);
        this.stepDetailsComposite.setLayout((Layout)new FillLayout());
        return stepAreaComposite;
    }

    protected Composite createButtonBarComposite(Composite parent) {
        Composite buttonBarComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttonBarComposite.setLayout((Layout)layout);
        this.createButton(buttonBarComposite, 0, StringConstants.WZ_SETUP_BTN_BACK);
        this.createButton(buttonBarComposite, 1, StringConstants.WZ_SETUP_BTN_NEXT);
        this.createButton(buttonBarComposite, 2, StringConstants.DIA_FINISH);
        this.createButton(buttonBarComposite, 3, StringConstants.DIA_CANCEL);
        layout.numColumns = this.buttonMap.size();
        return buttonBarComposite;
    }

    protected final Button createButton(Composite buttonBarComposite, int id, String text) {
        Button button = new Button(buttonBarComposite, 0x800000);
        button.setLayoutData((Object)this.getButtonGridData());
        button.setText(text);
        this.buttonMap.put(id, button);
        button.setData(StringConstants.ID, (Object)id);
        return button;
    }

    public void create() {
        this.buttonMap = new HashMap<Integer, Button>();
        super.create();
        this.setInput();
        this.registerControlModifyListeners();
    }

    protected void registerControlModifyListeners() {
        ButtonClickedListener buttonClickedListener = new ButtonClickedListener();
        for (Map.Entry<Integer, Button> buttonEntry : this.buttonMap.entrySet()) {
            buttonEntry.getValue().addSelectionListener((SelectionListener)buttonClickedListener);
        }
    }

    protected void wizardButtonPress(int id) {
        switch (id) {
            case 0: {
                this.backPressed();
                break;
            }
            case 1: {
                this.nextPressed();
                break;
            }
            case 2: {
                this.finishPressed();
                break;
            }
            case 3: {
                this.cancelPressed();
            }
        }
    }

    protected void setInput() {
        this.sharedData = new HashMap();
        this.wizardManager = new WizardManager();
        for (IWizardPage wizardPage : this.getWizardPages()) {
            this.wizardManager.addPage(wizardPage);
        }
        this.showPage(this.wizardManager.getCurrentPage());
    }

    protected abstract Collection<IWizardPage> getWizardPages();

    protected void showPage(IWizardPage page) {
        if (page == null) {
            return;
        }
        if (page instanceof AbstractWizardPage) {
            ((AbstractWizardPage)page).addChangedListeners(this);
        }
        this.updateStepArea(page);
        this.updateButtonBar(page);
        page.setInput(this.sharedData);
        page.registerControlModifyListeners();
    }

    private void updateStepArea(IWizardPage page) {
        while (this.stepDetailsComposite.getChildren().length > 0) {
            this.stepDetailsComposite.getChildren()[0].dispose();
        }
        page.createStepArea(this.stepDetailsComposite);
        this.stepDetailsComposite.layout(true, true);
    }

    private void updateButtonBar(IWizardPage page) {
        this.getButton(2).setEnabled(page.canFinish() && page.canFlipToNextPage());
        this.getButton(0).setEnabled(this.wizardManager.getWizardPages().indexOf(page) > 0);
        this.getButton(1).setEnabled(page.canFlipToNextPage() && this.wizardManager.getWizardPages().indexOf(page) < this.wizardManager.getWizardPages().size() - 1);
    }

    protected final void backPressed() {
        Map<String, Object> pageSharedData = this.wizardManager.getCurrentPage().storeControlStates();
        if (pageSharedData != null) {
            this.sharedData.putAll(pageSharedData);
        }
        this.showPage(this.wizardManager.backPage());
    }

    protected final void nextPressed() {
        Map<String, Object> pageSharedData = this.wizardManager.getCurrentPage().storeControlStates();
        if (pageSharedData != null) {
            this.sharedData.putAll(pageSharedData);
        }
        this.showPage(this.wizardManager.nextPage());
    }

    protected void finishPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private GridData getButtonGridData() {
        GridData buttonGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        buttonGridData.widthHint = 80;
        return buttonGridData;
    }

    protected void createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    @Override
    public void handlePageChanged(WizardPageChangedEvent event) {
        if (event.getWizardPage() == null || !event.getWizardPage().equals(this.wizardManager.getCurrentPage())) {
            return;
        }
        this.updateButtonBar(event.getWizardPage());
    }

    protected Button getButton(int id) {
        return this.buttonMap.get(id);
    }

    private class ButtonClickedListener
    extends SelectionAdapter {
        private ButtonClickedListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.isDisposed()) {
                return;
            }
            SimpleWizardDialog.this.wizardButtonPress((Integer)e.widget.getData(StringConstants.ID));
        }
    }
}

