/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.events.KeyEvent;

public class KeyEventUtil {
    public static boolean isKeysPressed(KeyEvent keyEvent, String keys) {
        try {
            return KeyEventUtil.getKeysPressed(keyEvent).equalsIgnoreCase(KeyStroke.getInstance((String)keys).format());
        }
        catch (ParseException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public static boolean isKeysPressed(KeyEvent keyEvent, String[] keys) {
        return KeyEventUtil.isKeysPressed(keyEvent, KeyEventUtil.getKeys(keys));
    }

    public static boolean isKeysPressed(KeyEvent keyEvent, int naturalKey) {
        return KeyEventUtil.isKeysPressed(keyEvent, 0, naturalKey);
    }

    public static boolean isKeysPressed(KeyEvent keyEvent, int modifierKey, int naturalKey) {
        return KeyEventUtil.getKeysPressed(keyEvent).equalsIgnoreCase(KeyStroke.getInstance((int)modifierKey, (int)naturalKey).format());
    }

    public static String getKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])keys, (String)"+");
    }

    public static String geNativeKeyLabel(String[] keys) {
        String keysCombination = KeyEventUtil.getKeys(keys);
        try {
            return KeyStroke.getInstance((String)keysCombination).format();
        }
        catch (ParseException e) {
            LoggerSingleton.logError((Throwable)e);
            return keysCombination;
        }
    }

    private static String getKeysPressed(KeyEvent keyEvent) {
        return KeyStroke.getInstance((int)keyEvent.stateMask, (int)keyEvent.keyCode).format();
    }
}

