/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.control.CMenu;
import com.kms.katalon.entity.file.FileEntity;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;

public class ControlUtils {
    private static final String UPDATING_LAYOUT = "updatingLayout";
    public static final int DF_CONTROL_HEIGHT = 18;
    public static final int DF_VERTICAL_SPACING = 10;
    public static final int DF_HORIZONTAL_SPACING = 10;
    private static final int DELAY_IN_MILLIS = 50;
    public static final int MENU_OPEN_ID = 100;
    public static Listener getAutoHideStyledTextScrollbarListener = new Listener(){

        public void handleEvent(final Event event) {
            final StyledText t = (StyledText)event.widget;
            Rectangle r1 = t.getClientArea();
            final Rectangle r2 = t.computeTrim(r1.x, r1.y, r1.width, r1.height);
            final Point p = t.computeSize(-1, -1, true);
            t.getDisplay().timerExec(50, new Runnable(){

                @Override
                public void run() {
                    if (t.isDisposed() || Boolean.TRUE.equals(t.getData(ControlUtils.UPDATING_LAYOUT))) {
                        return;
                    }
                    t.setRedraw(false);
                    t.setData(ControlUtils.UPDATING_LAYOUT, (Object)true);
                    try {
                        ScrollBar verticalBar;
                        ScrollBar horizontalBar = t.getHorizontalBar();
                        if (horizontalBar != null) {
                            horizontalBar.setVisible(!t.getWordWrap() && r2.width < p.x);
                        }
                        if ((verticalBar = t.getVerticalBar()) != null) {
                            verticalBar.setVisible(r2.height < p.y);
                        }
                        if (event.type == 24) {
                            ControlUtils.updateParentLayout((Control)t);
                            t.showSelection();
                        }
                    }
                    finally {
                        t.setData(ControlUtils.UPDATING_LAYOUT, (Object)false);
                        t.setRedraw(true);
                    }
                }
            });
        }
    };

    private ControlUtils() {
    }

    public static void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                ControlUtils.recursiveSetEnabled(c, enabled);
                c.setEnabled(enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    public static void recursivelyAddMouseListener(Control ctrl, MouseAdapter mouseAdapter) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                ControlUtils.recursivelyAddMouseListener(c, mouseAdapter);
                ++n2;
            }
        }
        ctrl.addMouseListener((MouseListener)mouseAdapter);
    }

    public static Font getFontBold(Control control) {
        return ControlUtils.getFontStyle(control, 1);
    }

    public static Font getFontItalic(Control control) {
        return ControlUtils.getFontStyle(control, 2);
    }

    public static Font getFontBoldItalic(Control control) {
        return ControlUtils.getFontStyle(control, 3);
    }

    public static Font getFontStyle(Control control, int style) {
        return ControlUtils.getFontStyle(control, style, -1);
    }

    public static Font getFontStyle(Control control, int style, int size) {
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)control.getFont());
        if (size != -1) {
            return fontDescriptor.setStyle(style).setHeight(size).createFont((Device)control.getDisplay());
        }
        return fontDescriptor.setStyle(style).createFont((Device)control.getDisplay());
    }

    public static void setFontToBeBold(Control ctrl) {
        ctrl.setFont(ControlUtils.getFontBold(ctrl));
    }

    public static void setFontStyle(Control control, int style, int size) {
        control.setFont(ControlUtils.getFontStyle(control, style, size));
    }

    public static void setFontSize(Control ctrl, int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Font's size must be a positive number");
        }
        FontData[] fD = ctrl.getFont().getFontData();
        fD[0].setHeight(height);
        ctrl.setFont(new Font((Device)ctrl.getDisplay(), fD));
    }

    private static void updateParentLayout(Control ctrl) {
        Composite parentComposite = ctrl.getParent();
        if (parentComposite != null) {
            parentComposite.layout(true);
        }
    }

    public static void removeOldOpenMenuItem(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getID() == 100) {
                item.dispose();
                return;
            }
            ++n2;
        }
    }

    public static void createOpenMenuWhenSelectOnlyOne(CMenu menu, FileEntity entity, Callable<Boolean> enableWhenItemSelected, SelectionAdapter adapter) {
        if (entity == null) {
            return;
        }
        MenuItem openMenuItem = menu.createMenuItemWithoutSelectionListener(ComposerComponentsImplMessageConstants.MENU_OPEN, null, enableWhenItemSelected, 8);
        openMenuItem.setID(100);
        openMenuItem.setText(ControlUtils.getFileEntityMenuItemLabel(entity));
        openMenuItem.setData((Object)entity);
        openMenuItem.addSelectionListener((SelectionListener)adapter);
    }

    public static void createOpenMenuWhenSelectOnlyOne(final Menu menu, FileEntity entity, final TableViewer viewer, SelectionAdapter adapter) {
        if (entity == null) {
            return;
        }
        MenuItem openMenuItem = new MenuItem(menu, 8);
        openMenuItem.setText(ControlUtils.getFileEntityMenuItemLabel(entity));
        openMenuItem.setID(100);
        openMenuItem.setData((Object)entity);
        viewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                menu.setEnabled(!viewer.getSelection().isEmpty());
            }
        });
        openMenuItem.addSelectionListener((SelectionListener)adapter);
    }

    public static void createSubMenuOpen(Menu subMenu, FileEntity fileEntity, SelectionAdapter selectionAdapter, String name) {
        if (fileEntity == null) {
            return;
        }
        MenuItem menuItem = new MenuItem(subMenu, 8);
        menuItem.setText(name);
        menuItem.setData((Object)fileEntity);
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private static String getFileEntityMenuItemLabel(FileEntity entity) {
        return String.valueOf(ComposerComponentsImplMessageConstants.MENU_OPEN) + " " + entity.getName();
    }

    public static boolean isReady(Control control) {
        return control != null && !control.isDisposed();
    }

    public static String createMenuItemText(String name, String hotkey) {
        if (StringUtils.isEmpty((String)hotkey)) {
            return name;
        }
        return String.valueOf(name) + "\t" + hotkey;
    }
}

