/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.webui.constants.HTMLTags;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.io.File;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class WebElementTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = -736426078298872979L;
    private static final String OBJECT_TYPE_NAME = StringConstants.TREE_OBJECT_TYPE_NAME;
    public static final String KEY_WORD = "ob";
    public static final String[] SEARCH_TAGS = new String[]{"id", "name"};
    private WebElementEntity webElement;

    public WebElementTreeEntity(WebElementEntity webElement, ITreeEntity parentTreeEntity) {
        super((FileEntity)webElement, parentTreeEntity);
        this.webElement = webElement;
    }

    @Override
    public Object getObject() throws Exception {
        ObjectRepositoryController.getInstance().reloadTestObject(this.webElement, (Entity)this.entity);
        this.loadAllDescentdantEntities();
        return this.webElement;
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public Image getImage() throws Exception {
        block86: {
            block89: {
                WebServiceRequestEntity wsEntity;
                block87: {
                    if (!(this.webElement instanceof WebServiceRequestEntity)) break block86;
                    wsEntity = (WebServiceRequestEntity)this.webElement;
                    if (!wsEntity.getServiceType().equals(WebServiceRequestEntity.SERVICE_TYPES[1])) break block87;
                    switch (((WebServiceRequestEntity)this.webElement).getRestRequestMethod()) {
                        case "GET": {
                            return ImageConstants.IMG_16_WS_GET_METHOD;
                        }
                        case "POST": {
                            return ImageConstants.IMG_16_WS_POST_METHOD;
                        }
                        case "PUT": {
                            return ImageConstants.IMG_16_WS_PUT_METHOD;
                        }
                        case "DELETE": {
                            return ImageConstants.IMG_16_WS_DELETE_METHOD;
                        }
                        case "PATCH": {
                            return ImageConstants.IMG_16_WS_PATCH_METHOD;
                        }
                        case "CONNECT": {
                            return ImageConstants.IMG_16_WS_CONNECT_METHOD;
                        }
                        case "HEAD": {
                            return ImageConstants.IMG_16_WS_HEAD_METHOD;
                        }
                        case "OPTIONS": {
                            return ImageConstants.IMG_16_WS_OPTIONS_METHOD;
                        }
                        case "TRACE": {
                            return ImageConstants.IMG_16_WS_TRACE_METHOD;
                        }
                    }
                    return ImageConstants.IMG_16_WS_CUSTOM_METHOD;
                }
                if (!wsEntity.getServiceType().equals(WebServiceRequestEntity.SERVICE_TYPES[0])) break block89;
                switch (((WebServiceRequestEntity)this.webElement).getSoapRequestMethod()) {
                    case "GET": {
                        return ImageConstants.IMG_16_WS_SOAP_GET_METHOD;
                    }
                    case "POST": {
                        return ImageConstants.IMG_16_WS_SOAP_POST_METHOD;
                    }
                    case "SOAP": {
                        return ImageConstants.IMG_16_WS_SOAP_METHOD;
                    }
                    case "SOAP12": {
                        return ImageConstants.IMG_16_WS_SOAP12_METHOD;
                    }
                }
                return ImageConstants.IMG_16_WS_GET_METHOD;
            }
            return ImageConstants.IMG_16_WS_TEST_OBJECT;
        }
        WebElementEntity webElement = (WebElementEntity)this.getObject();
        switch (HTMLTags.getElementType((String)webElement.getPropertyValue("tag"), (String)webElement.getPropertyValue("type"))) {
            case "a": {
                return ImageConstants.IMG_16_LNK_TEST_OBJECT;
            }
            case "button": 
            case "submit": 
            case "reset": {
                return ImageConstants.IMG_16_BTN_TEST_OBJECT;
            }
            case "checkbox": {
                return ImageConstants.IMG_16_CHK_TEST_OBJECT;
            }
            case "file": {
                return ImageConstants.IMG_16_FILE_TEST_OBJECT;
            }
            case "img": 
            case "image": {
                return ImageConstants.IMG_16_IMG_TEST_OBJECT;
            }
            case "select": {
                return ImageConstants.IMG_16_CBX_TEST_OBJECT;
            }
            case "label": {
                return ImageConstants.IMG_16_LBL_TEST_OBJECT;
            }
            case "textarea": 
            case "text": {
                return ImageConstants.IMG_16_TXT_TEST_OBJECT;
            }
            case "radio": {
                return ImageConstants.IMG_16_RBT_TEST_OBJECT;
            }
        }
        return ImageConstants.IMG_16_TEST_OBJECT;
    }

    public String getTypeName() throws Exception {
        return OBJECT_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return TreeEntityTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.WEBELEMENT.toString();
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof WebElementEntity) {
            this.entity = (FileEntity)object;
            this.webElement = (WebElementEntity)object;
        }
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("name")) {
            return this.webElement.getName();
        }
        if (key.equals("id")) {
            return this.webElement.getRelativePathForUI().replace(File.separator, "/");
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() throws Exception {
    }

    public boolean canAddToObjectSpy() {
        return !(this.webElement instanceof WebServiceRequestEntity);
    }
}

