/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.handler;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.handler.PartActionHandler;
import com.kms.katalon.entity.file.FileEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class OpenFileEntityHandler<T extends FileEntity>
implements PartActionHandler<T> {
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    protected IEventBroker eventBroker;

    @PostConstruct
    protected void initialize() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (OpenFileEntityHandler.this.isElementInstanceOf(object)) {
                    OpenFileEntityHandler.this.execute((FileEntity)object);
                }
            }
        });
    }

    protected void execute(T fileEntity) {
        String partId = this.getPartId(fileEntity);
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
        if (mPart == null) {
            mPart = (MPart)this.modelService.createModelElement(MPart.class);
            mPart.setElementId(partId);
            mPart.setLabel(fileEntity.getName());
            mPart.setIconURI(this.getIconURI());
            mPart.setContributionURI(this.getContributionURI());
            mPart.setTooltip(fileEntity.getIdForDisplay());
            mPart.setCloseable(true);
            stack.getChildren().add(mPart);
        }
        if (mPart.getObject() == null) {
            mPart.setObject(fileEntity);
        }
        this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
        stack.setSelectedElement((MUIElement)mPart);
    }

    protected EModelService getModelService() {
        return this.modelService;
    }

    protected MApplication getApplication() {
        return this.application;
    }

    protected abstract Class<? extends T> getEntityType();

    private boolean isElementInstanceOf(Object element) {
        Class<T> clazz = this.getEntityType();
        return clazz != null && clazz.isInstance(element);
    }
}

