/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.providers.CellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;

public class CustomTableEditor
extends TableEditor {
    private static final int DF_EXTENDED_SPACE = 0;
    private CTableViewer tableViewer;
    private int columnIndex;

    public CustomTableEditor(CTableViewer tableViewer) {
        super(tableViewer.getTable());
        this.tableViewer = tableViewer;
        this.columnIndex = 0;
    }

    public void setEditor(Control editor, TableItem item, int column) {
        super.setEditor(editor, item, column);
        this.columnIndex = column;
    }

    public void layout() {
        super.layout();
        Control editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Rectangle rect = editor.getBounds();
        int extendedSpace = this.getExtendedSpace();
        editor.setBounds(rect.x + extendedSpace, rect.y, rect.width - extendedSpace, rect.height);
    }

    protected int getExtendedSpace() {
        TypeCheckedStyleCellLabelProvider<?> cellLabelProvider = this.tableViewer.getCellLabelProvider(this.columnIndex);
        if (cellLabelProvider == null) {
            return 0;
        }
        CellLayoutInfo cellLayoutInfo = cellLabelProvider.getCellLayoutInfo();
        if (cellLayoutInfo == null) {
            return 0;
        }
        return cellLayoutInfo.getLeftMargin() + cellLayoutInfo.getSpace();
    }
}

