/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TreeEntitySelectionDialog
extends ElementTreeSelectionDialog {
    private Text txtInput;
    private CLabel lblSearch;
    private IEntityLabelProvider labelProvider;
    private AbstractEntityViewerFilter entityViewerFilter;
    private boolean isSearched;
    private TreeViewer treeViewer;

    public TreeEntitySelectionDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider, AbstractEntityViewerFilter entityViewerFilter) {
        super(parent, (IBaseLabelProvider)labelProvider, contentProvider);
        this.labelProvider = labelProvider;
        this.entityViewerFilter = entityViewerFilter;
    }

    public TreeViewer createTreeViewer(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(parent, 2048);
        searchComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glSearchComposite = new GridLayout(2, false);
        glSearchComposite.verticalSpacing = 0;
        glSearchComposite.horizontalSpacing = 0;
        glSearchComposite.marginWidth = 0;
        glSearchComposite.marginHeight = 0;
        searchComposite.setLayout((Layout)glSearchComposite);
        GridData grSearchComposite = new GridData(768);
        grSearchComposite.heightHint = 24;
        searchComposite.setLayoutData((Object)grSearchComposite);
        this.txtInput = new Text(searchComposite, 0);
        this.txtInput.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.txtInput.setMessage(StringConstants.DIA_SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtInput.setLayoutData((Object)gdTxtInput);
        this.txtInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeEntitySelectionDialog.this.filterSearchedText();
            }
        });
        Canvas canvasSearch = new Canvas(searchComposite, 0);
        canvasSearch.setLayout((Layout)new FillLayout(256));
        canvasSearch.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.isSearched = false;
        this.lblSearch = new CLabel((Composite)canvasSearch, 0);
        this.lblSearch.setBackground(searchComposite.getBackground());
        this.updateStatusSearchLabel();
        this.lblSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.lblSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (TreeEntitySelectionDialog.this.isSearched) {
                    TreeEntitySelectionDialog.this.isSearched = !TreeEntitySelectionDialog.this.isSearched;
                    TreeEntitySelectionDialog.this.txtInput.setText("");
                }
            }
        });
        this.treeViewer = super.createTreeViewer(parent);
        this.expandTreeViewerToInitialElements();
        this.treeViewer.addFilter((ViewerFilter)this.entityViewerFilter);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.getTree().setFocus();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeEntitySelectionDialog.this.updateOKButtonStatus();
            }
        });
        return this.treeViewer;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.updateOKButtonStatus();
        }
    }

    private void updateOKButtonStatus() {
        Button btnOk = this.getButton(0);
        if (btnOk != null && !btnOk.isDisposed()) {
            btnOk.setEnabled(this.treeViewer.getStructuredSelection().size() > 0);
        }
    }

    public void create() {
        super.create();
        this.updateOKButtonStatus();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new CTreeViewer(parent, style);
    }

    protected void expandTreeViewerToInitialElements() {
        if (this.getInitialElementSelections() != null && !this.getInitialElementSelections().isEmpty()) {
            this.getTreeViewer().expandToLevel(this.getInitialElementSelections().get(0), -1);
        }
    }

    protected void updateStatusSearchLabel() {
        if (this.isSearched) {
            this.lblSearch.setImage(ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.DIA_IMAGE_CLOSE_SEARCH_TOOLTIP);
        } else {
            this.lblSearch.setImage(ImageConstants.IMG_16_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.DIA_IMAGE_SEARCH_TOOLTIP);
        }
    }

    protected String getSearchMessage() {
        try {
            return String.valueOf(StringConstants.DIA_KEYWORD_SEARCH_ALL) + ":" + this.txtInput.getText();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    protected void filterSearchedText() {
        final String searchString = this.txtInput.getText();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TreeEntitySelectionDialog.this.txtInput.isDisposed()) {
                        return;
                    }
                    if (searchString.equals(TreeEntitySelectionDialog.this.txtInput.getText()) && TreeEntitySelectionDialog.this.getTreeViewer().getInput() != null) {
                        String broadcastMessage = TreeEntitySelectionDialog.this.getSearchMessage();
                        TreeEntitySelectionDialog.this.labelProvider.setSearchString(broadcastMessage);
                        TreeEntitySelectionDialog.this.entityViewerFilter.setSearchString(broadcastMessage);
                        TreeEntitySelectionDialog.this.getTreeViewer().refresh();
                        if (searchString != null && !searchString.isEmpty()) {
                            TreeEntitySelectionDialog.this.isSearched = true;
                            TreeEntitySelectionDialog.this.getTreeViewer().expandAll();
                        } else {
                            TreeEntitySelectionDialog.this.isSearched = false;
                            TreeEntitySelectionDialog.this.getTreeViewer().collapseAll();
                        }
                        TreeEntitySelectionDialog.this.updateStatusSearchLabel();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }
}

