/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiStatusErrorDialog
extends AbstractDialog {
    private static final int DF_HEIGHT_HINT_FOR_DETAILS_COMPOSITE = 150;
    private Label lblTitle;
    private Label lblDescription;
    private String title;
    private String errorDescription;
    private String detailsMessage;
    private GridData detailsCompositeGridData;
    private Composite mainComposite;
    private StyledText txtDetails;
    private boolean detailsShowed;
    private Composite detailsComposite;

    private MultiStatusErrorDialog(Shell parentShell, String errorMessage, String errorReason, String detailsMessage) {
        super(parentShell);
        this.title = errorMessage;
        this.errorDescription = errorReason;
        this.detailsMessage = detailsMessage;
        this.detailsShowed = false;
    }

    protected Control createContents(Composite parent) {
        this.mainComposite = (Composite)super.createContents(parent);
        this.createDetailsComposite(this.mainComposite);
        return this.mainComposite;
    }

    private void createDetailsComposite(Composite parentComposite) {
        this.detailsComposite = new Composite(parentComposite, 0);
        this.detailsComposite.setLayout((Layout)new GridLayout(1, false));
        this.detailsCompositeGridData = new GridData(4, 4, true, false, 1, 1);
        this.detailsCompositeGridData.heightHint = 150;
        this.detailsComposite.setLayoutData((Object)this.detailsCompositeGridData);
        this.txtDetails = new StyledText(this.detailsComposite, 2626);
        this.txtDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtDetails.setEditable(false);
    }

    @Override
    protected Control createDialogContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite imageComposite = new Composite(composite, 0);
        imageComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        imageComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblImage = new Label(imageComposite, 0);
        lblImage.setImage(this.getShell().getDisplay().getSystemImage(8));
        Composite container = new Composite(composite, 0);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.marginHeight = 0;
        glContainer.marginWidth = 0;
        container.setLayout((Layout)glContainer);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblTitle = new Label(container, 64);
        this.lblTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblReasonTitle = new Label(container, 0);
        lblReasonTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblReasonTitle.setText(StringConstants.DIA_TITLE_REASON);
        this.lblDescription = new Label(container, 64);
        this.lblDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return composite;
    }

    @Override
    protected void registerControlModifyListeners() {
        this.txtDetails.addListener(11, ControlUtils.getAutoHideStyledTextScrollbarListener);
        this.getButton(13).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiStatusErrorDialog.this.detailsShowed = !MultiStatusErrorDialog.this.detailsShowed;
                MultiStatusErrorDialog.this.updateDetailsCompositeAndButton();
            }
        });
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.WARN;
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 13, this.getDetailsButtonText(), false);
    }

    @Override
    protected void setInput() {
        this.lblTitle.setText(StringUtils.defaultString((String)this.title));
        this.lblDescription.setText(StringUtils.defaultString((String)this.errorDescription));
        this.txtDetails.setText(StringUtils.defaultString((String)this.detailsMessage));
        this.updateDetailsCompositeAndButton();
    }

    private void updateDetailsCompositeAndButton() {
        this.detailsComposite.setVisible(this.detailsShowed);
        this.detailsCompositeGridData.exclude = !this.detailsShowed;
        String detailsButtonText = this.getDetailsButtonText();
        this.getButton(13).setText(detailsButtonText);
        this.updateDialogSize();
    }

    private void updateDialogSize() {
        Point currentSize = this.getShell().getSize();
        int detailsHeight = this.detailsComposite.getSize().y;
        int newY = this.detailsShowed ? currentSize.y + detailsHeight : currentSize.y - detailsHeight;
        this.getShell().setSize(currentSize.x, newY);
    }

    private String getDetailsButtonText() {
        String detailsButtonText = StringConstants.DIA_TITLE_DETAILS;
        return this.detailsShowed ? "<< " + detailsButtonText : String.valueOf(detailsButtonText) + " >>";
    }

    public static void showErrorDialog(Throwable e, String title, String errorDescription) {
        MultiStatusErrorDialog dialog = new MultiStatusErrorDialog(Display.getCurrent().getActiveShell(), title, errorDescription, e.getMessage());
        dialog.open();
    }

    public static void showErrorDialog(String message, String reason, String details) {
        MultiStatusErrorDialog dialog = new MultiStatusErrorDialog(Display.getCurrent().getActiveShell(), message, reason, details);
        dialog.open();
    }
}

