/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.command.KCommand;
import com.kms.katalon.composer.components.impl.command.KatalonCommands;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.util.EntityIndexingUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.HttpRequestController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.exception.NullAttributeException;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CommandPaletteDialog
extends Dialog {
    private Composite mainComposite;
    private ListViewer listCommand;
    private Text txtCommand;
    private IEventBroker eventBroker;
    private EventHandler loadCommandsEventHandler;
    private EntityIndexingUtil entityIndexingUtil;
    private KatalonCommands katalonCommands;

    public CommandPaletteDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(65536);
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        this.katalonCommands = KatalonCommands.getInstance();
        try {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                return;
            }
            this.entityIndexingUtil = EntityIndexingUtil.getInstance(currentProject);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        Composite mainContainer = new Composite(this.mainComposite, 0);
        mainContainer.setBackground(ColorUtil.getToolBarBackgroundColor());
        mainContainer.setLayout((Layout)new GridLayout());
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtCommand = new Text(mainContainer, 2048);
        this.txtCommand.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.txtCommand.setMessage(ComposerComponentsImplMessageConstants.DIA_TXT_MSG_COMMAND_PALETTE);
        this.txtCommand.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.listCommand = new ListViewer(mainContainer, 2820);
        org.eclipse.swt.widgets.List list = this.listCommand.getList();
        list.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listCommand.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listCommand.setComparator(new ViewerComparator());
        this.listCommand.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (CommandPaletteDialog.this.isKCommand(element)) {
                    return ((KCommand)element).getName();
                }
                return super.getText(element);
            }
        });
        this.listCommand.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!CommandPaletteDialog.this.isKCommand(element)) {
                    return false;
                }
                String commandName = ((KCommand)element).getName().toLowerCase();
                String inputText = CommandPaletteDialog.this.txtCommand.getText().toLowerCase();
                return commandName.contains(inputText);
            }
        });
        Label lblHint = new Label(mainContainer, 0);
        lblHint.setText(ComposerComponentsImplMessageConstants.DIA_LBL_PRESS_ESC_TO_CLOSE);
        lblHint.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        lblHint.setBackground(ColorUtil.getToolBarBackgroundColor());
        this.addListeners();
        this.populateCommand(this.katalonCommands.getRootCommand().getChildren());
        return this.mainComposite;
    }

    private void addListeners() {
        final org.eclipse.swt.widgets.List list = this.listCommand.getList();
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CommandPaletteDialog.this.performCommand();
            }
        });
        list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CommandPaletteDialog.this.onEnterPressed(e);
            }
        });
        this.txtCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CommandPaletteDialog.this.listCommand == null) {
                    return;
                }
                CommandPaletteDialog.this.listCommand.refresh();
                list.setSelection(0);
            }
        });
        this.txtCommand.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int currentIndex = list.getSelectionIndex();
                if (e.keyCode == 0x1000002) {
                    e.doit = false;
                    int maxIndex = list.getItemCount() - 1;
                    int downIndex = currentIndex < maxIndex ? currentIndex + 1 : maxIndex;
                    Object item = CommandPaletteDialog.this.listCommand.getElementAt(downIndex);
                    if (item == null) {
                        return;
                    }
                    CommandPaletteDialog.this.listCommand.setSelection((ISelection)new StructuredSelection(item), true);
                    return;
                }
                if (e.keyCode == 0x1000001) {
                    e.doit = false;
                    int upIndex = currentIndex > 0 ? currentIndex - 1 : 0;
                    Object item = CommandPaletteDialog.this.listCommand.getElementAt(upIndex);
                    if (item == null) {
                        return;
                    }
                    CommandPaletteDialog.this.listCommand.setSelection((ISelection)new StructuredSelection(item), true);
                }
            }

            public void keyReleased(KeyEvent e) {
                CommandPaletteDialog.this.onEnterPressed(e);
            }
        });
        this.getShell().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    CommandPaletteDialog.this.close();
                }
            }
        });
        this.getShell().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CommandPaletteDialog.this.txtCommand.forceFocus();
            }
        });
        this.loadCommandsEventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                final KCommand command = (KCommand)EventUtil.getData(event);
                if (command == null) {
                    return;
                }
                BusyIndicator.showWhile((Display)CommandPaletteDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String endpointEventName = (String)command.getEventData();
                        if (endpointEventName == null) {
                            return;
                        }
                        switch (endpointEventName) {
                            case "TESTCASE/OPEN": 
                            case "TESTCASE/ADD_STEP/CALL_TESTCASE": {
                                CommandPaletteDialog.this.populateCommand(KatalonCommands.createCommands(CommandPaletteDialog.this.getTestCaseIds(), endpointEventName));
                                break;
                            }
                            case "TESTSUITE/OPEN": {
                                CommandPaletteDialog.this.populateCommand(KatalonCommands.createCommands(CommandPaletteDialog.this.getTestSuiteIds(), endpointEventName));
                                break;
                            }
                            case "TESTOBJECT/OPEN": {
                                CommandPaletteDialog.this.populateCommand(KatalonCommands.createCommands(CommandPaletteDialog.this.getTestObjectIds(), endpointEventName));
                                break;
                            }
                            case "TESTDATA/OPEN": {
                                CommandPaletteDialog.this.populateCommand(KatalonCommands.createCommands(CommandPaletteDialog.this.getTestDataIds(), endpointEventName));
                                break;
                            }
                            case "CHECKPOINT/OPEN": {
                                CommandPaletteDialog.this.populateCommand(KatalonCommands.createCommands(CommandPaletteDialog.this.getCheckpointIds(), endpointEventName));
                                break;
                            }
                            case "KATALON/UPDATE_HELP_CONTENTS": {
                                List onlineHelpContents = CommandPaletteDialog.this.getOnlineHelpContents();
                                if (onlineHelpContents.isEmpty()) {
                                    CommandPaletteDialog.this.close();
                                    break;
                                }
                                CommandPaletteDialog.this.populateCommand(onlineHelpContents);
                                break;
                            }
                            default: {
                                CommandPaletteDialog.this.close();
                            }
                        }
                    }
                });
            }
        };
        this.eventBroker.subscribe("KATALON/LOAD_COMMANDS", this.loadCommandsEventHandler);
    }

    protected void performCommand() {
        try {
            KCommand command = (KCommand)((StructuredSelection)this.listCommand.getSelection()).getFirstElement();
            if (command == null) {
                return;
            }
            if (command.hasChildren()) {
                this.populateCommand(command.getChildren());
                return;
            }
            this.performEventAction(command);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void performEventAction(KCommand command) throws Exception {
        String eventName = command.getEventName();
        if (eventName == null) {
            this.close();
            return;
        }
        String commandName = command.getName();
        switch (eventName) {
            case "TESTCASE/OPEN": {
                EventUtil.post(eventName, TestCaseController.getInstance().getTestCaseByDisplayId(commandName));
                this.close();
                return;
            }
            case "TESTOBJECT/OPEN": {
                WebElementEntity testobject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(commandName);
                String event = testobject instanceof WebServiceRequestEntity ? "WSOBJECT/OPEN" : eventName;
                EventUtil.post(event, testobject);
                this.close();
                return;
            }
            case "TESTDATA/OPEN": {
                EventUtil.post(eventName, TestDataController.getInstance().getTestDataByDisplayId(commandName));
                this.close();
                return;
            }
            case "TESTSUITE/OPEN": {
                TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(commandName, ProjectController.getInstance().getCurrentProject());
                if (testSuite == null) {
                    EventUtil.post("TEST_SUITE_COLLECTION/OPEN", commandName);
                } else {
                    EventUtil.post(eventName, testSuite);
                }
                this.close();
                return;
            }
            case "CHECKPOINT/OPEN": {
                EventUtil.post(eventName, CheckpointController.getInstance().getByDisplayedId(commandName));
                this.close();
                return;
            }
            case "KATALON/LOAD_COMMANDS": {
                EventUtil.post(eventName, command);
                return;
            }
            case "KATALON/OPEN_URL": {
                String url = ObjectUtils.toString((Object)command.getEventData());
                if (StringUtils.isNotBlank((String)url)) {
                    Program.launch((String)url);
                }
                this.close();
                return;
            }
            case "TESTCASE/ADD_STEP/CALL_TESTCASE": {
                EventUtil.post(eventName, new Object[]{this.getActivePartId(), TestCaseController.getInstance().getTestCaseByDisplayId(commandName)});
                this.close();
                return;
            }
            case "TESTCASE/ADD_STEP": {
                EventUtil.post(eventName, new Object[]{this.getActivePartId(), command.getEventData()});
                this.close();
                return;
            }
        }
        EventUtil.post(eventName, command.getEventData());
        this.close();
    }

    private String getActivePartId() {
        return this.katalonCommands.getSelectedPartIdInComposerContentArea();
    }

    private void populateCommand(List<KCommand> commands) {
        if (this.txtCommand == null || this.listCommand == null) {
            return;
        }
        this.txtCommand.setText(StringConstants.EMPTY);
        this.listCommand.getList().removeAll();
        this.listCommand.setInput((Object)commands.toArray(new KCommand[0]));
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    protected Point getInitialLocation(Point initialSize) {
        int y = ((MWindow)ApplicationSingleton.getInstance().getApplication().getChildren().get(0)).getY() + 90;
        return new Point(super.getInitialLocation((Point)initialSize).x, y);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    private void onEnterPressed(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.performCommand();
        }
    }

    public boolean close() {
        this.eventBroker.unsubscribe(this.loadCommandsEventHandler);
        return super.close();
    }

    private List<String> getTestCaseIds() {
        if (this.entityIndexingUtil == null) {
            return Collections.emptyList();
        }
        return this.entityIndexingUtil.getIndexedEntityIds(TestCaseEntity.getTestCaseFileExtension());
    }

    private List<String> getTestSuiteIds() {
        if (this.entityIndexingUtil == null) {
            return Collections.emptyList();
        }
        return this.entityIndexingUtil.getIndexedEntityIds(TestSuiteEntity.getTestSuiteFileExtension());
    }

    private List<String> getTestObjectIds() {
        if (this.entityIndexingUtil == null) {
            return Collections.emptyList();
        }
        return this.entityIndexingUtil.getIndexedEntityIds(WebElementEntity.getWebElementFileExtension());
    }

    private List<String> getTestDataIds() {
        if (this.entityIndexingUtil == null) {
            return Collections.emptyList();
        }
        return this.entityIndexingUtil.getIndexedEntityIds(DataFileEntity.getTestDataFileExtension());
    }

    private List<String> getCheckpointIds() {
        if (this.entityIndexingUtil == null) {
            return Collections.emptyList();
        }
        return this.entityIndexingUtil.getIndexedEntityIds(CheckpointEntity.getCheckpointFileExtension());
    }

    private List<KCommand> getOnlineHelpContents() {
        try {
            String jsonContent = HttpRequestController.getInstance().get(ComposerComponentsImplMessageConstants.DIA_KATALON_HELP_JSON_URL).text();
            KCommand onlineHelpCommand = (KCommand)JsonUtil.fromJson((String)jsonContent, KCommand.class);
            if (onlineHelpCommand == null || !onlineHelpCommand.hasChildren()) {
                throw new NullAttributeException(ComposerComponentsImplMessageConstants.DIA_NO_ONLINE_HELP_CONTENT);
            }
            List<KCommand> childrenCommands = onlineHelpCommand.getChildren();
            childrenCommands.sort(new Comparator<KCommand>(){

                @Override
                public int compare(KCommand cmd1, KCommand cmd2) {
                    return cmd1.getName().compareTo(cmd2.getName());
                }
            });
            PlatformUI.getPreferenceStore().setValue("general.onlineHelpContent", JsonUtil.toJson((Object)onlineHelpCommand, (boolean)false));
            return childrenCommands;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialogWithLink.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)ComposerComponentsImplMessageConstants.DIA_EXC_MSG_UNABLE_TO_LOAD_ONLINE_HELP_CONTENT);
            return Collections.emptyList();
        }
    }

    private boolean isKCommand(Object object) {
        return object != null && KCommand.class.getName().equals(object.getClass().getName());
    }
}

