/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.entity.folder.FolderEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AbstractEntityDialog
extends TitleAreaDialog {
    private static final int BASE_NUMBER_COLUMN = 2;
    private static final int DIFF_SIZE = 1;
    private static final int H_GAP_IMAGE = 5;
    private String name = "";
    private String windowTitle = StringConstants.DIA_WINDOW_TITLE_NEW;
    private String lblName = StringConstants.DIA_LBL_NAME;
    private String dialogTitle = "";
    private String dialogMsg = StringConstants.DIA_LBL_CREATE_NEW;
    private int msgType = 1;
    protected Text txtName;
    protected Composite container;
    protected FolderEntity parentFolder;
    private boolean isFileEntity = true;
    private Composite wholeArea;
    private Label messageImageLabel;
    private Text messageLabel;
    private Point imageLocation;
    private Point textLocation;

    public AbstractEntityDialog(Shell parentShell, FolderEntity parentFolder) {
        super(parentShell);
        this.parentFolder = parentFolder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getWindowTitle());
    }

    protected Control createContents(Composite parent) {
        this.wholeArea = (Composite)super.createContents(parent);
        Control[] controls = this.wholeArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Text && i != 0 && controls[i - 1] instanceof Label) {
                this.messageLabel = (Text)controls[i];
                this.messageImageLabel = (Label)controls[i - 1];
                break;
            }
            ++i;
        }
        return this.wholeArea;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.createDialogBodyArea(area);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return area;
    }

    public Control createDialogBodyArea(Composite parent) {
        GridLayout gLayout;
        if (this.container == null) {
            this.container = new Composite(parent, 0);
        }
        int numColumns = (gLayout = (GridLayout)this.container.getLayout()) != null && gLayout.numColumns > 2 ? gLayout.numColumns : 2;
        int span = numColumns - 2;
        this.createEntityNameControl(this.container, numColumns, span);
        this.createEntityCustomControl(this.container, numColumns, span);
        return this.container;
    }

    private Control createEntityNameControl(Composite parent, int column, int span) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelName = new Label(parent, 0);
        labelName.setText(this.getLblName());
        this.txtName = new Text(parent, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(this.getName());
        this.txtName.selectAll();
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractEntityDialog.this.setName(((Text)e.getSource()).getText());
                AbstractEntityDialog.this.updateStatus();
            }
        });
        if (span > 0) {
            AbstractEntityDialog.createEmptySpace(parent, span);
        }
        return parent;
    }

    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        return parent;
    }

    public void updateStatus() {
        super.getButton(0).setEnabled(this.isValidEntityName());
    }

    private boolean isValidEntityName() {
        String entityName = this.getName();
        try {
            EntityNameController.getInstance().validateName(entityName);
            this.validateEntityName(entityName);
            this.setErrorMessage(null);
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    public void validateEntityName(String entityName) throws Exception {
        if (!StringUtils.equalsIgnoreCase((String)EntityNameController.getInstance().getAvailableName(entityName, this.parentFolder, !this.isFileEntity()), (String)entityName)) {
            throw new InvalidNameException(StringConstants.DIA_NAME_EXISTED);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateStatus();
        this.setErrorMessage(null);
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    public void create() {
        super.create();
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMsg(), this.getMsgType());
    }

    protected boolean isResizable() {
        return false;
    }

    public static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.trim().replaceAll("\\s+", " ");
        }
        this.name = name;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getLblName() {
        return this.lblName;
    }

    public void setLblName(String lblName) {
        this.lblName = lblName;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getDialogMsg() {
        return this.dialogMsg;
    }

    public void setDialogMsg(String dialogMsg) {
        this.dialogMsg = dialogMsg;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public boolean isFileEntity() {
        return this.isFileEntity;
    }

    public void setFileEntity(boolean isFileEntity) {
        this.isFileEntity = isFileEntity;
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        if (this.wholeArea == null) {
            return;
        }
        this.customizeMessageImage();
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this.wholeArea == null) {
            return;
        }
        this.customizeMessageImage();
    }

    private void customizeMessageImage() {
        Image newImage = this.getImage(this.messageImageLabel);
        this.messageImageLabel.setImage(newImage);
        Rectangle imageBound = newImage.getBounds();
        this.messageImageLabel.setSize(imageBound.width, imageBound.height);
        if (!this.messageImageLabel.getVisible()) {
            this.messageImageLabel.setVisible(true);
        }
        this.setTextAndImageAlign();
    }

    private Image getImage(Label messageLabel) {
        Image oldImage = messageLabel.getImage();
        if (oldImage == null) {
            return null;
        }
        if (oldImage.equals((Object)JFaceResources.getImage((String)"dialog_messasge_info_image"))) {
            return ImageConstants.IMG_20_INFO_MSG;
        }
        if (oldImage.equals((Object)JFaceResources.getImage((String)"dialog_message_error_image"))) {
            return ImageConstants.IMG_20_ERROR_MSG;
        }
        if (oldImage.equals((Object)JFaceResources.getImage((String)"dialog_messasge_warning_image"))) {
            return ImageConstants.IMG_20_WARNING_MSG;
        }
        return oldImage;
    }

    private void setTextAndImageAlign() {
        if (this.imageLocation == null) {
            this.imageLocation = this.messageImageLabel.getLocation();
        }
        if (this.textLocation == null) {
            this.textLocation = this.messageLabel.getLocation();
        }
        int messageImagePosX = this.imageLocation.x + 1;
        int messagePosX = messageImagePosX + this.messageImageLabel.getBounds().width + 5;
        this.messageLabel.setLocation(messagePosX, this.textLocation.y);
        this.messageImageLabel.setLocation(messageImagePosX, this.imageLocation.y - 1);
    }
}

