/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CDropdownBox
extends Composite {
    private Shell popup;
    private Listener listener;
    private Table table;
    private TableColumn labelColumn;
    private CLabel selectedLabel = new CLabel((Composite)this, 0);
    private CLabel arrowLabel;
    private int selectionIndex = -1;
    private boolean selectionEventDisabled = false;
    private String[] items;
    private TableColumn imageColumn;

    public CDropdownBox(Composite parent, int style, Image imageLabel) {
        super(parent, style);
        this.selectedLabel.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.selectedLabel.setImage(imageLabel);
        this.arrowLabel = new CLabel((Composite)this, 0);
        this.arrowLabel.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        this.arrowLabel.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (CDropdownBox.this.isDisposed()) {
                    return;
                }
                if (CDropdownBox.this.selectedLabel == event.widget || CDropdownBox.this.arrowLabel == event.widget) {
                    CDropdownBox.this.labelEvent(event);
                    return;
                }
                if (CDropdownBox.this.popup == event.widget) {
                    CDropdownBox.this.popupEvent(event);
                    return;
                }
                if (CDropdownBox.this.table == event.widget) {
                    CDropdownBox.this.tableEvent(event);
                }
                if (CDropdownBox.this == event.widget) {
                    CDropdownBox.this.comboEvent(event);
                }
            }
        };
        int[] comboEvents = new int[]{11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], this.listener);
            ++i;
        }
        int[] labelEvents = new int[]{3};
        int i2 = 0;
        while (i2 < labelEvents.length) {
            this.selectedLabel.addListener(labelEvents[i2], this.listener);
            this.arrowLabel.addListener(labelEvents[i2], this.listener);
            ++i2;
        }
        this.createPopup();
    }

    public void setItems(String[] items) {
        this.items = items;
        this.selectionIndex = 0;
        this.updateTableItems();
        this.refreshLabel();
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.selectedLabel.setToolTipText(string);
    }

    private void labelEvent(Event event) {
        switch (event.type) {
            case 3: {
                if (this.popup == null) break;
                this.dropDown(!this.isDropped());
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point labelSize = this.selectedLabel.computeSize(-1, -1, changed);
        Point arrowSize = this.arrowLabel.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        return new Point(labelSize.x + arrowSize.x + 2 * borderWidth + 1, labelSize.y + 2 + 2 * borderWidth);
    }

    private void comboEvent(Event event) {
        switch (event.type) {
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.table.getBounds();
                Color black = ColorUtil.getCompositeBackgroundColor();
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 23: {
                if (!"linux".equals(Platform.getOS())) break;
                this.dropDown(false);
            }
        }
    }

    public void createPopup() {
        this.popup = new Shell(this.getShell(), 16392);
        int[] popupEvents = new int[]{21, 9, 23};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        this.table = new Table((Composite)this.popup, 67584);
        this.table.setBackground(ColorUtil.getDefaultBackgroundColor());
        this.imageColumn = new TableColumn(this.table, 0x1000000);
        this.imageColumn.setWidth(ImageConstants.IMG_16_CHECK.getBounds().width + 2);
        this.labelColumn = new TableColumn(this.table, 0);
        int[] tableEvents = new int[]{13, 15, 16, 4};
        int i2 = 0;
        while (i2 < tableEvents.length) {
            this.table.addListener(tableEvents[i2], this.listener);
            ++i2;
        }
        this.clearInput();
    }

    private void updateLabelBackground(boolean isDroped) {
        if (isDroped) {
            this.selectedLabel.setBackground(ColorUtil.getDefaultBackgroundColor());
            this.arrowLabel.setBackground(ColorUtil.getDefaultBackgroundColor());
            this.setBackground(ColorUtil.getDefaultBackgroundColor());
        } else {
            Color nullColor = null;
            this.selectedLabel.setBackground(nullColor);
            this.arrowLabel.setBackground(nullColor);
            this.setBackground(nullColor);
        }
    }

    private void tableEvent(Event event) {
        switch (event.type) {
            case 13: {
                if (this.selectionEventDisabled) break;
                this.selectionIndex = this.table.getSelectionIndex();
                this.refreshLabel();
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point labelPoint = this.selectedLabel.toControl(this.getDisplay().getCursorLocation());
                    Point labelSize = this.selectedLabel.getSize();
                    Point arrowPoint = this.arrowLabel.toControl(this.getDisplay().getCursorLocation());
                    Point arrowSize = this.arrowLabel.getSize();
                    Rectangle rect = new Rectangle(0, 0, labelSize.x, labelSize.y);
                    Rectangle arrowRect = new Rectangle(0, 0, arrowSize.x, arrowSize.y);
                    if (rect.contains(labelPoint) || arrowRect.contains(arrowPoint)) {
                        boolean comboShellActivated;
                        boolean bl = comboShellActivated = this.getDisplay().getActiveShell() == this.getShell();
                        if (comboShellActivated) break;
                        this.dropDown(false);
                        break;
                    }
                }
                this.dropDown(false);
                break;
            }
            case 4: {
                this.dropDown(false);
            }
        }
    }

    private void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int height = rect.height;
        Point labelSize = this.selectedLabel.computeSize(-1, height, changed);
        Point arrowSize = this.arrowLabel.computeSize(-1, height, changed);
        this.selectedLabel.setBounds(0, 0, labelSize.x, height);
        this.arrowLabel.setBounds(labelSize.x, 0, arrowSize.x, arrowSize.y);
    }

    private void updateTableItems() {
        try {
            this.table.removeAll();
            int i = 0;
            while (i < this.items.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                if (i == this.selectionIndex) {
                    tableItem.setImage(0, ImageConstants.IMG_16_CHECK);
                }
                tableItem.setText(1, this.items[i]);
                ++i;
            }
            this.table.setSelection(this.selectionIndex >= 0 ? this.selectionIndex : 0);
            this.labelColumn.pack();
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    private void dropDown(boolean drop) {
        this.updateLabelBackground(drop);
        if (!drop) {
            this.popup.setVisible(false);
        } else {
            this.selectionEventDisabled = true;
            this.updateTableItems();
            Point tableSize = this.table.computeSize(-1, -1, true);
            if (!"macosx".equals(Platform.getOS())) {
                tableSize.x -= ImageConstants.IMG_16_CHECK.getBounds().width;
            }
            tableSize.y -= ImageConstants.IMG_16_CHECK.getBounds().height;
            this.table.setBounds(1, 1, tableSize.x + 8, tableSize.y + 6);
            Point comboSize = this.getSize();
            Display display = this.getDisplay();
            Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
            this.popup.setBounds(parentRect.x - 1, comboSize.y + parentRect.y + 1, tableSize.x + 10, tableSize.y + 8);
            this.popup.setVisible(true);
            this.table.setFocus();
            this.selectionEventDisabled = false;
        }
    }

    public void redraw() {
        super.redraw();
        this.selectedLabel.redraw();
        this.arrowLabel.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    private boolean isDropped() {
        return !this.isDisposed() && this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.selectedLabel.isFocusControl() || this.arrowLabel.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    private void refreshLabel() {
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!CDropdownBox.this.table.isDisposed()) {
                    if (CDropdownBox.this.items != null && CDropdownBox.this.items.length > 0) {
                        if (CDropdownBox.this.selectionIndex < 0) {
                            CDropdownBox.this.selectionIndex = 0;
                        }
                        CDropdownBox.this.selectedLabel.setText(CDropdownBox.this.items[CDropdownBox.this.selectionIndex]);
                    } else {
                        CDropdownBox.this.selectedLabel.setText("<none>");
                    }
                    CDropdownBox.this.selectedLabel.pack();
                    CDropdownBox.this.selectedLabel.getParent().layout();
                    CDropdownBox.this.selectedLabel.getParent().getParent().layout();
                } else {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public void clearInput() {
        this.table.removeAll();
        this.refreshLabel();
    }

    public void setSelectionIndex(int selectionIndex) {
        this.selectionIndex = selectionIndex;
        this.refreshLabel();
    }
}

