/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.templates;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssist;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuCreator;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurroundWithTemplateMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    public static final String SURROUND_WITH_QUICK_MENU_ACTION_ID = "org.eclipse.jdt.ui.edit.text.java.surround.with.quickMenu";
    private static final String GROOVY_TEMPLATE_PREFERENCE_PAGE_ID = "org.codehaus.groovy.eclipse.quickfix.preferencepage.template";
    private static final String CODE_TEMPLATE_PREFERENCE_PAGE_ID = "org.eclipse.jdt.ui.preferences.CodeTemplatePreferencePage";
    private static final String TEMPLATE_GROUP = "templateGroup";
    private static final String CONFIG_GROUP = "configGroup";
    private static Action NONE_APPLICABLE_ACTION = new Action(ActionMessages.SurroundWithTemplateMenuAction_NoneApplicable){

        public void run() {
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;
    private IPartService fPartService;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            SurroundWithTemplateMenuAction.this.disposeMenuItems();
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    protected void disposeMenuItems() {
        if (this.fMenu == null || this.fMenu.isDisposed()) {
            return;
        }
        MenuItem[] items = this.fMenu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItem = items[i];
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
            ++i;
        }
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public static void fillMenu(IMenuManager menu, CompilationUnitEditor editor) {
        IAction[] actions = SurroundWithTemplateMenuAction.getTemplateActions((JavaEditor)editor);
        if (actions == null || actions.length == 0) {
            menu.add((IAction)NONE_APPLICABLE_ACTION);
        } else {
            menu.add((IContributionItem)new Separator(TEMPLATE_GROUP));
            int i = 0;
            while (actions != null && i < actions.length) {
                menu.add(actions[i]);
                ++i;
            }
        }
        menu.add((IContributionItem)new Separator(CONFIG_GROUP));
        menu.add((IAction)new ConfigureTemplatesAction());
    }

    public void dispose() {
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        this.setMenu(null);
    }

    public void init(IWorkbenchWindow window) {
        IPartService partService;
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        if (window != null && (partService = window.getPartService()) != null) {
            this.fPartService = partService;
            partService.addPartListener(this.fPartListener);
        }
    }

    public void run(IAction action) {
        IWorkbenchPart activePart = JavaPlugin.getActivePage().getActivePart();
        if (!(activePart instanceof CompilationUnitEditor)) {
            return;
        }
        final CompilationUnitEditor editor = (CompilationUnitEditor)activePart;
        new JDTQuickMenuCreator((JavaEditor)editor){

            protected void fillMenu(IMenuManager menu) {
                SurroundWithTemplateMenuAction.fillMenu(menu, editor);
            }
        }.createMenu();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void fillMenu(Menu menu) {
        boolean hasTemplateActions;
        IWorkbenchPart activePart = JavaPlugin.getActivePage().getActivePart();
        if (!(activePart instanceof CompilationUnitEditor)) {
            ActionContributionItem item = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            item.fill(menu, -1);
            return;
        }
        CompilationUnitEditor editor = (CompilationUnitEditor)activePart;
        if (editor.isBreadcrumbActive()) {
            ActionContributionItem item = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            item.fill(menu, -1);
            return;
        }
        IAction[] actions = SurroundWithTemplateMenuAction.getTemplateActions((JavaEditor)editor);
        boolean bl = hasTemplateActions = actions != null && actions.length > 0;
        if (!hasTemplateActions) {
            ActionContributionItem item = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            item.fill(menu, -1);
        } else if (hasTemplateActions) {
            int i = 0;
            while (i < actions.length) {
                ActionContributionItem item = new ActionContributionItem(actions[i]);
                item.fill(menu, -1);
                ++i;
            }
        }
        Separator configGroup = new Separator(CONFIG_GROUP);
        configGroup.fill(menu, -1);
        ActionContributionItem configAction = new ActionContributionItem((IAction)new ConfigureTemplatesAction());
        configAction.fill(menu, -1);
    }

    protected void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SurroundWithTemplateMenuAction.this.fillMenu(m);
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    private static IAction[] getTemplateActions(JavaEditor editor) {
        ITextSelection textSelection = SurroundWithTemplateMenuAction.getTextSelection(editor);
        if (textSelection == null || textSelection.getLength() == 0) {
            return null;
        }
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (!(cu instanceof GroovyCompilationUnit)) {
            return null;
        }
        GroovyQuickAssist quickTemplateProcessor = new GroovyQuickAssist();
        AssistContext context = new AssistContext(cu, editor.getViewer(), (IEditorPart)editor, textSelection.getOffset(), textSelection.getLength());
        List<IJavaCompletionProposal> proposals = quickTemplateProcessor.getTemplateAssists((IQuickAssistInvocationContext)context, (GroovyCompilationUnit)cu);
        if (proposals == null || proposals.size() == 0) {
            return null;
        }
        return SurroundWithTemplateMenuAction.getActionsFromProposals(proposals, context.getSelectionOffset(), (ITextViewer)editor.getViewer());
    }

    private static ITextSelection getTextSelection(JavaEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    private static boolean isInJavadoc(JavaEditor editor) {
        ITextSelection selection = SurroundWithTemplateMenuAction.getTextSelection(editor);
        if (selection == null) {
            return false;
        }
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        try {
            String contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)selection.getOffset(), (boolean)true);
            return contentType.equals("__java_javadoc");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static IAction[] getActionsFromProposals(List<IJavaCompletionProposal> proposals, final int offset, final ITextViewer viewer) {
        ArrayList<5> result = new ArrayList<5>();
        int j = 1;
        for (IJavaCompletionProposal cnadidate : proposals) {
            if (!(cnadidate instanceof ICompletionProposalExtension2)) continue;
            final IJavaCompletionProposal proposal = cnadidate;
            StringBuffer actionName = new StringBuffer();
            if (j < 10) {
                actionName.append('&').append(j).append(' ');
            }
            actionName.append(cnadidate.getDisplayString());
            Action action = new Action(actionName.toString()){

                public void run() {
                    SurroundWithTemplateMenuAction.applyProposal((ICompletionProposal)proposal, viewer, '\u0000', 0, offset);
                }
            };
            action.setImageDescriptor(JavaPluginImages.DESC_OBJS_TEMPLATE);
            result.add(action);
            ++j;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new IAction[result.size()]);
    }

    private static void applyProposal(ICompletionProposal proposal, ITextViewer viewer, char trigger, int stateMask, final int offset) {
        Assert.isTrue((boolean)(proposal instanceof ICompletionProposalExtension2));
        IRewriteTarget target = null;
        IEditingSupportRegistry registry = null;
        IEditingSupport helper = new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion focus) {
                return focus.getOffset() <= offset && focus.getOffset() + focus.getLength() >= offset;
            }

            public boolean ownsFocusShell() {
                return false;
            }
        };
        try {
            IDocument document = viewer.getDocument();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (viewer instanceof IEditingSupportRegistry) {
                registry = (IEditingSupportRegistry)viewer;
                registry.register(helper);
            }
            ((ICompletionProposalExtension2)proposal).apply(viewer, trigger, stateMask, offset);
            Point selection = proposal.getSelection(document);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
            if (registry != null) {
                registry.unregister(helper);
            }
        }
    }

    private static class ConfigureTemplatesAction
    extends Action {
        public ConfigureTemplatesAction() {
            super(ActionMessages.SurroundWithTemplateMenuAction_ConfigureTemplatesActionName);
        }

        public void run() {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)SurroundWithTemplateMenuAction.GROOVY_TEMPLATE_PREFERENCE_PAGE_ID, (String[])new String[]{SurroundWithTemplateMenuAction.GROOVY_TEMPLATE_PREFERENCE_PAGE_ID, SurroundWithTemplateMenuAction.CODE_TEMPLATE_PREFERENCE_PAGE_ID}, null);
            preferenceDialog.getTreeViewer().expandAll();
            preferenceDialog.open();
        }

        private Shell getShell() {
            return JavaPlugin.getActiveWorkbenchWindow().getShell();
        }
    }
}

