/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.quickfix.proposals.AddClassCastResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.AddGroovyRuntimeResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.AddMissingGroovyImportsResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.AddUnimplementedResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ConvertToGroovyFileResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.IQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemDescriptor;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyQuickFixResolverRegistry {
    private QuickFixProblemContext problem;
    private Map<ProblemType, List<IQuickFixResolver>> registry;

    public GroovyQuickFixResolverRegistry(QuickFixProblemContext problem) {
        this.problem = problem;
    }

    protected QuickFixProblemContext getQuickFixProblem() {
        return this.problem;
    }

    public List<IQuickFixResolver> getQuickFixResolvers() {
        ProblemDescriptor descriptor = this.getQuickFixProblem().getProblemDescriptor();
        return descriptor != null ? this.getRegistry().get((Object)descriptor.getType()) : null;
    }

    protected Map<ProblemType, List<IQuickFixResolver>> getRegistry() {
        if (this.registry == null) {
            IQuickFixResolver[] registeredResolvers;
            this.registry = new HashMap<ProblemType, List<IQuickFixResolver>>();
            IQuickFixResolver[] iQuickFixResolverArray = registeredResolvers = GroovyQuickFixResolverRegistry.getRegisteredResolvers(this.getQuickFixProblem());
            int n = registeredResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IQuickFixResolver resolver = iQuickFixResolverArray[n2];
                List<ProblemType> types = resolver.getProblemTypes();
                for (ProblemType type : types) {
                    List<IQuickFixResolver> resolvers = this.registry.get((Object)type);
                    if (resolvers == null) {
                        resolvers = new ArrayList<IQuickFixResolver>();
                        this.registry.put(type, resolvers);
                    }
                    resolvers.add(resolver);
                }
                ++n2;
            }
        }
        return this.registry;
    }

    protected static IQuickFixResolver[] getRegisteredResolvers(QuickFixProblemContext problem) {
        return new IQuickFixResolver[]{new ConvertToGroovyFileResolver(problem), new AddMissingGroovyImportsResolver(problem), new AddGroovyRuntimeResolver(problem), new AddUnimplementedResolver(problem), new AddClassCastResolver(problem)};
    }
}

