/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractGroovyQuickFixProposal;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.codehaus.groovy.eclipse.ui.utils.GroovyResourceUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToGroovyFileResolver
extends AbstractQuickFixResolver {
    public static final String DESCRIPTION = "Convert to Groovy file and open in Groovy editor";

    public ConvertToGroovyFileResolver(QuickFixProblemContext problem) {
        super(problem);
    }

    @Override
    protected ProblemType[] getTypes() {
        return new ProblemType[]{ProblemType.MISSING_SEMI_COLON_TYPE, ProblemType.MISSING_SEMI_COLON_TYPE_VARIANT};
    }

    @Override
    public List<IJavaCompletionProposal> getQuickFixProposals() {
        ArrayList<IJavaCompletionProposal> fixes = new ArrayList<IJavaCompletionProposal>();
        fixes.add(new ConvertToGroovyQuickFix(this.getQuickFixProblem()));
        return fixes;
    }

    public static class ConvertToGroovyQuickFix
    extends AbstractGroovyQuickFixProposal {
        public ConvertToGroovyQuickFix(QuickFixProblemContext problem) {
            super(problem);
        }

        protected String getImageBundleLocation() {
            return "org.eclipse.jdt.ui.correction_change.gif";
        }

        public void apply(IDocument document) {
            IResource resource = this.getQuickFixProblemContext().getResource();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            resources.add(resource);
            GroovyResourceUtil.renameFile((String)".groovy", resources);
        }

        public String getDisplayString() {
            return ConvertToGroovyFileResolver.DESCRIPTION;
        }
    }
}

