/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.codeassist.relevance.RelevanceRules;
import org.codehaus.groovy.eclipse.quickfix.GroovyQuickFixPlugin;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractGroovyQuickFixProposal;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.groovy.eclipse.refactoring.actions.TypeSearch;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMissingGroovyImportsResolver
extends AbstractQuickFixResolver {
    public AddMissingGroovyImportsResolver(QuickFixProblemContext problem) {
        super(problem);
    }

    @Override
    protected ProblemType[] getTypes() {
        return new ProblemType[]{ProblemType.MISSING_IMPORTS_TYPE};
    }

    protected List<IType> getImportTypeSuggestions() {
        int offset = this.getQuickFixProblem().getOffset();
        try {
            String simpleTypeName = this.getUnresolvedSimpleName();
            if (simpleTypeName != null) {
                HashMap<String, OrganizeGroovyImports.UnresolvedTypeData> unresolvedTypes = new HashMap<String, OrganizeGroovyImports.UnresolvedTypeData>();
                unresolvedTypes.put(simpleTypeName, new OrganizeGroovyImports.UnresolvedTypeData(simpleTypeName, false, (ISourceRange)new SourceRange(offset, simpleTypeName.length())));
                new TypeSearch().searchForTypes(this.getGroovyCompilationUnit(), unresolvedTypes);
                OrganizeGroovyImports.UnresolvedTypeData foundData = (OrganizeGroovyImports.UnresolvedTypeData)unresolvedTypes.get(simpleTypeName);
                List matches = foundData.getFoundInfos();
                if (matches != null) {
                    ArrayList<IType> suggestions = new ArrayList<IType>();
                    for (TypeNameMatch match : matches) {
                        suggestions.add(match.getType());
                    }
                    return suggestions;
                }
            }
        }
        catch (JavaModelException e) {
            GroovyQuickFixPlugin.log(e);
        }
        return null;
    }

    protected String getUnresolvedSimpleName() {
        String[] messages = this.getQuickFixProblem().getProblemDescriptor().getMarkerMessages();
        if (messages == null || messages.length == 0) {
            return null;
        }
        String[] stringArray = ProblemType.MISSING_IMPORTS_TYPE.groovyProblemSnippets;
        int n = ProblemType.MISSING_IMPORTS_TYPE.groovyProblemSnippets.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern;
            Matcher matcher;
            String text = stringArray[n2];
            int startIndex = messages[0].indexOf(text);
            if (startIndex >= 0 && (matcher = (pattern = Pattern.compile("\\b\\w+\\b")).matcher(messages[0].substring(startIndex + text.length()))).find()) {
                return AddMissingGroovyImportsResolver.getTopLevelType(matcher.group());
            }
            ++n2;
        }
        return null;
    }

    protected static String getTopLevelType(String simpleName) {
        int firstIndex;
        int n = firstIndex = simpleName != null ? simpleName.indexOf(46) : -1;
        if (firstIndex >= 0) {
            simpleName = simpleName.substring(0, firstIndex);
        }
        return simpleName;
    }

    @Override
    public List<IJavaCompletionProposal> getQuickFixProposals() {
        List<IType> suggestions = this.getImportTypeSuggestions();
        if (suggestions != null) {
            ArrayList<IJavaCompletionProposal> fixes = new ArrayList<IJavaCompletionProposal>();
            for (IType type : suggestions) {
                int revelance = this.getRelevance(type);
                fixes.add(new AddMissingImportProposal(type, this.getGroovyCompilationUnit(), this.getQuickFixProblem(), revelance));
            }
            return fixes;
        }
        return null;
    }

    protected GroovyCompilationUnit getGroovyCompilationUnit() {
        return (GroovyCompilationUnit)this.getQuickFixProblem().getCompilationUnit();
    }

    protected int getRelevance(IType type) {
        if (type == null) {
            return 0;
        }
        return RelevanceRules.ALL_RULES.getRelevance(type, this.getContextTypes());
    }

    public static class AddMissingImportProposal
    extends AbstractGroovyQuickFixProposal {
        private IType resolvedSuggestedType;
        private GroovyCompilationUnit unit;

        public AddMissingImportProposal(IType resolvedSuggestedType, GroovyCompilationUnit unit, QuickFixProblemContext problem, int relevance) {
            super(problem, relevance);
            this.resolvedSuggestedType = resolvedSuggestedType;
            this.unit = unit;
        }

        public IType getSuggestedJavaType() {
            return this.resolvedSuggestedType;
        }

        protected String getImageBundleLocation() {
            return "org.eclipse.jdt.ui.imp_obj.gif";
        }

        protected ImportRewrite getImportRewrite() {
            ImportRewrite rewriter = null;
            try {
                rewriter = ImportRewrite.create((ICompilationUnit)this.unit, (boolean)true);
            }
            catch (JavaModelException e) {
                GroovyQuickFixPlugin.log(e);
            }
            return rewriter;
        }

        public void apply(IDocument document) {
            ImportRewrite rewrite = this.getImportRewrite();
            if (rewrite != null) {
                rewrite.addImport(this.getSuggestedJavaType().getFullyQualifiedName('.'));
                try {
                    TextEdit edit = rewrite.rewriteImports(null);
                    if (edit != null) {
                        this.unit.applyTextEdit(edit, null);
                    }
                }
                catch (JavaModelException e) {
                    GroovyQuickFixPlugin.log(e);
                }
                catch (CoreException e) {
                    GroovyQuickFixPlugin.log(e);
                }
            }
        }

        public String getDisplayString() {
            IType declaringType = this.getSuggestedJavaType().getDeclaringType();
            String declaration = declaringType != null ? declaringType.getFullyQualifiedName().replace('$', '.') : this.getSuggestedJavaType().getPackageFragment().getElementName();
            return "Import '" + this.getSuggestedJavaType().getElementName() + "' (" + declaration + ")";
        }
    }
}

