/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractGroovyQuickFixProposal;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGroovyRuntimeResolver
extends AbstractQuickFixResolver {
    protected AddGroovyRuntimeResolver(QuickFixProblemContext problem) {
        super(problem);
    }

    @Override
    public List<IJavaCompletionProposal> getQuickFixProposals() {
        IJavaProject project = this.getQuickFixProblem().getCompilationUnit().getJavaProject();
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>(2);
        try {
            if (!GroovyRuntime.hasGroovyClasspathContainer((IJavaProject)project)) {
                proposals.add(new AddGroovyRuntimeProposal(project, this.getQuickFixProblem(), 100));
                return proposals;
            }
        }
        catch (CoreException e) {
            GroovyCore.logWarning((String)"Problem calculating quickfixes", (Throwable)e);
        }
        return null;
    }

    @Override
    protected ProblemType[] getTypes() {
        return new ProblemType[]{ProblemType.MISSING_CLASSPATH_CONTAINER_TYPE};
    }

    public static class AddGroovyRuntimeProposal
    extends AbstractGroovyQuickFixProposal {
        private final IJavaProject project;

        public AddGroovyRuntimeProposal(IJavaProject project, QuickFixProblemContext problem, int relevance) {
            super(problem, relevance);
            this.project = project;
        }

        public void apply(IDocument document) {
            GroovyRuntime.addGroovyClasspathContainer((IJavaProject)this.project);
        }

        public String getDisplayString() {
            return "Add Groovy Runtime to classpath";
        }

        protected String getImageBundleLocation() {
            return "org.eclipse.jdt.ui.library_obj.gif";
        }
    }
}

