/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.eclipse.quickfix.GroovyQuickFixPlugin;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractGroovyQuickFixProposal;
import org.codehaus.groovy.eclipse.quickfix.proposals.AbstractQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddClassCastResolver
extends AbstractQuickFixResolver {
    private static final Set<String> DEFAULT_IMPORTS = new HashSet<String>();

    static {
        DEFAULT_IMPORTS.add("java.io.*");
        DEFAULT_IMPORTS.add("java.lang.*");
        DEFAULT_IMPORTS.add("java.math.BigDecimal");
        DEFAULT_IMPORTS.add("java.math.BigInteger");
        DEFAULT_IMPORTS.add("java.net.*");
        DEFAULT_IMPORTS.add("java.util.*");
        DEFAULT_IMPORTS.add("groovy.lang.*");
        DEFAULT_IMPORTS.add("groovy.util.*");
    }

    protected AddClassCastResolver(QuickFixProblemContext problem) {
        super(problem);
    }

    @Override
    public List<IJavaCompletionProposal> getQuickFixProposals() {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add(new AddClassCastProposal(this.getQuickFixProblem(), (GroovyCompilationUnit)this.getQuickFixProblem().getCompilationUnit()));
        return proposals;
    }

    @Override
    protected ProblemType[] getTypes() {
        return new ProblemType[]{ProblemType.STATIC_TYPE_CHECKING_CANNOT_ASSIGN};
    }

    public static class AddClassCastProposal
    extends AbstractGroovyQuickFixProposal {
        private GroovyCompilationUnit unit;
        private String typeName;

        public AddClassCastProposal(QuickFixProblemContext problem, GroovyCompilationUnit unit) {
            super(problem);
            this.unit = unit;
            this.typeName = this.calculateTypeName();
        }

        public void apply(IDocument document) {
            QuickFixProblemContext problemContext = this.getQuickFixProblemContext();
            int offset = problemContext.getOffset();
            InsertEdit insertEdit = new InsertEdit(offset, "(" + this.typeName + ") ");
            try {
                this.unit.applyTextEdit((TextEdit)insertEdit, null);
            }
            catch (JavaModelException e) {
                GroovyQuickFixPlugin.log(e);
            }
        }

        public String getDisplayString() {
            return "Add cast to " + this.typeName;
        }

        protected String getImageBundleLocation() {
            return "org.eclipse.jdt.ui.correction_cast.gif";
        }

        private String calculateTypeName() {
            String message = this.getQuickFixProblemContext().getProblemDescriptor().getMarkerMessages()[0];
            String name = message.substring(message.lastIndexOf(" ") + 1);
            int lastDotPosition = name.lastIndexOf(".");
            if (DEFAULT_IMPORTS.contains(name)) {
                return name.substring(lastDotPosition + 1);
            }
            String starPackageName = String.valueOf(name.substring(0, lastDotPosition)) + ".*";
            if (DEFAULT_IMPORTS.contains(starPackageName)) {
                return name.substring(lastDotPosition + 1);
            }
            try {
                IImportDeclaration[] iImportDeclarationArray = this.unit.getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IImportDeclaration i = iImportDeclarationArray[n2];
                    if (i.getElementName().equals(name) || i.getElementName().equals(starPackageName)) {
                        return name.substring(lastDotPosition + 1);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GroovyQuickFixPlugin.log(e);
            }
            return name;
        }
    }
}

