/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.proposals;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.quickfix.proposals.IQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuickFixResolver
implements IQuickFixResolver {
    private List<ProblemType> problemTypes;
    private QuickFixProblemContext problem;

    protected AbstractQuickFixResolver(QuickFixProblemContext problem) {
        this.problem = problem;
    }

    protected QuickFixProblemContext getQuickFixProblem() {
        return this.problem;
    }

    @Override
    public List<ProblemType> getProblemTypes() {
        if (this.problemTypes == null) {
            this.problemTypes = new ArrayList<ProblemType>();
            ProblemType[] types = this.getTypes();
            if (types != null) {
                ProblemType[] problemTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    ProblemType type = problemTypeArray[n2];
                    if (type != null && !this.problemTypes.contains((Object)type)) {
                        this.problemTypes.add(type);
                    }
                    ++n2;
                }
            }
        }
        return this.problemTypes;
    }

    protected IType[] getContextTypes() {
        ICompilationUnit unit;
        QuickFixProblemContext context = this.getQuickFixProblem();
        if (context != null && (unit = context.getCompilationUnit()) != null) {
            try {
                return unit.getAllTypes();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected abstract ProblemType[] getTypes();
}

