/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.quickfix.proposals.GroovyQuickFixResolverRegistry;
import org.codehaus.groovy.eclipse.quickfix.proposals.IQuickFixResolver;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemDescriptor;
import org.codehaus.groovy.eclipse.quickfix.proposals.ProblemType;
import org.codehaus.groovy.eclipse.quickfix.proposals.QuickFixProblemContext;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class GroovyQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return this.isProblemInGroovyProject(unit) && ProblemType.isRecognizedProblemId(problemId);
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        List<IQuickFixResolver> resolvers;
        QuickFixProblemContext problemContext;
        if (this.isProblemInGroovyProject(context, locations) && (problemContext = this.getQuickFixProblemContext(context, locations)) != null && (resolvers = new GroovyQuickFixResolverRegistry(problemContext).getQuickFixResolvers()) != null) {
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            for (IQuickFixResolver resolver : resolvers) {
                List<IJavaCompletionProposal> foundProposals = resolver.getQuickFixProposals();
                if (foundProposals == null) continue;
                proposals.addAll(foundProposals);
            }
            return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
        }
        return new IJavaCompletionProposal[0];
    }

    protected QuickFixProblemContext getQuickFixProblemContext(IInvocationContext context, IProblemLocation[] locations) {
        if (context == null || locations == null || locations.length == 0) {
            return null;
        }
        IProblemLocation location = locations[0];
        ProblemDescriptor descriptor = this.getProblemDescriptor(location.getProblemId(), location.getMarkerType(), location.getProblemArguments());
        if (descriptor != null) {
            return new QuickFixProblemContext(descriptor, context, location);
        }
        return null;
    }

    public ProblemDescriptor getProblemDescriptor(int problemID, String markerDescription, String[] messages) {
        ProblemType type = ProblemType.getProblemType(problemID, markerDescription, messages);
        if (type != null) {
            return new ProblemDescriptor(type, messages);
        }
        return null;
    }

    protected boolean isProblemInGroovyProject(IInvocationContext context, IProblemLocation[] locations) {
        if (context != null && locations != null && locations.length > 0) {
            return this.isProblemInGroovyProject(context.getCompilationUnit());
        }
        return false;
    }

    protected boolean isProblemInGroovyProject(ICompilationUnit unit) {
        IProject project;
        IResource resource;
        return unit != null && (resource = unit.getResource()) != null && (project = resource.getProject()) != null && project.isAccessible() && GroovyNature.hasGroovyNature((IProject)project);
    }
}

