/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.quickassist.AbstractGroovyCompletionProposal;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class SwapOperandsCompletionProposal
extends AbstractGroovyCompletionProposal {
    private final GroovyCompilationUnit unit;
    private final int length;
    private final int offset;
    private BinaryExpression binaryExpression;

    public SwapOperandsCompletionProposal(IInvocationContext context) {
        super(context);
        ICompilationUnit compUnit = context.getCompilationUnit();
        this.unit = compUnit instanceof GroovyCompilationUnit ? (GroovyCompilationUnit)compUnit : null;
        this.length = context.getSelectionLength();
        this.offset = context.getSelectionOffset();
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        TextEdit thisEdit = this.findReplacement(document);
        try {
            if (thisEdit != null) {
                thisEdit.apply(document);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Oops.", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset, 0);
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Swap infix operands.";
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getImage(), this.getDisplayString(), this.getDisplayString());
    }

    protected String getImageBundleLocation() {
        return "org.eclipse.jdt.ui.correction_change.gif";
    }

    public boolean hasProposals() {
        BinaryExpression expr;
        Token operation;
        if (this.unit == null) {
            return false;
        }
        boolean result = false;
        Region region = new Region(this.offset, this.length);
        ASTNodeFinder finder = new ASTNodeFinder(region);
        ModuleNode moduleNode = this.unit.getModuleNode();
        ASTNode node = finder.doVisit(moduleNode);
        if (node instanceof BinaryExpression && this.isApplicableInfixOperator((operation = (expr = (BinaryExpression)node).getOperation()).getText())) {
            this.binaryExpression = expr;
            result = true;
        }
        return result;
    }

    private TextEdit findReplacement(IDocument doc) {
        try {
            return this.createEdit(doc, this.binaryExpression.getLeftExpression(), this.binaryExpression.getRightExpression());
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Exception during swapping infix operands.", (Throwable)e);
            return null;
        }
    }

    private TextEdit createEdit(IDocument doc, Expression left, Expression right) throws BadLocationException {
        MultiTextEdit edit = new MultiTextEdit();
        int leftStart = left.getStart();
        int rightStart = right.getStart();
        char[] contents = this.unit.getContents();
        char[] leftChars = CharOperation.subarray((char[])contents, (int)leftStart, (int)left.getEnd());
        char[] rightChars = CharOperation.subarray((char[])contents, (int)rightStart, (int)right.getEnd());
        String leftText = new String(leftChars).trim();
        String rightText = new String(rightChars).trim();
        edit.addChild((TextEdit)new ReplaceEdit(rightStart, rightText.length(), leftText));
        edit.addChild((TextEdit)new ReplaceEdit(leftStart, leftText.length(), rightText));
        return edit;
    }

    private boolean isApplicableInfixOperator(String test) {
        return test.equals("*") || test.equals("/") || test.equals("%") || test.equals("+") || test.equals("-") || test.equals("<<") || test.equals(">>") || test.equals(">>>") || test.equals("<") || test.equals(">") || test.equals("<=") || test.equals(">=") || test.equals("==") || test.equals("!=") || test.equals("&") || test.equals("^") || test.equals("|") || test.equals("&&") || test.equals("||");
    }
}

