/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.quickassist.AbstractGroovyCompletionProposal;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.ReplaceEdit;

public class SplitAssigmentCompletionProposal
extends AbstractGroovyCompletionProposal {
    private final GroovyCompilationUnit unit;
    private final int length;
    private final int offset;
    private DeclarationExpression expr;

    public SplitAssigmentCompletionProposal(IInvocationContext context) {
        super(context);
        ICompilationUnit compUnit = context.getCompilationUnit();
        this.unit = compUnit instanceof GroovyCompilationUnit ? (GroovyCompilationUnit)compUnit : null;
        this.length = context.getSelectionLength();
        this.offset = context.getSelectionOffset();
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        Expression left = this.expr.getLeftExpression();
        int insertAt = left.getEnd();
        try {
            int lineNr = document.getLineOfOffset(insertAt);
            String space = GroovyIndentationService.getLineLeadingWhiteSpace((IDocument)document, (int)lineNr);
            ReplaceEdit edits = new ReplaceEdit(insertAt, 0, "\n" + space + left.getText());
            if (edits != null) {
                edits.apply(document);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Oops.", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset, this.length + this.offset);
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Split declaration";
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getImage(), this.getDisplayString(), this.getDisplayString());
    }

    protected String getImageBundleLocation() {
        return "org.eclipse.jdt.ui.correction_change.gif";
    }

    public boolean hasProposals() {
        if (this.unit == null) {
            return false;
        }
        Region region = new Region(this.offset, this.length);
        ASTNodeFinder finder = new ASTNodeFinder(region);
        ModuleNode moduleNode = this.unit.getModuleNode();
        ASTNode node = finder.doVisit(moduleNode);
        if (node instanceof DeclarationExpression) {
            this.expr = (DeclarationExpression)node;
            return this.expr.getRightExpression() != null && !(this.expr.getLeftExpression() instanceof TupleExpression);
        }
        return false;
    }
}

