/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.quickassist.AbstractGroovyCompletionProposal;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.TextEdit;

public class RemoveUnnecessarySemicolonsCompletionProposal
extends AbstractGroovyCompletionProposal {
    private final int length;
    private final int offset;

    public RemoveUnnecessarySemicolonsCompletionProposal(IInvocationContext context) {
        super(context);
        this.length = context.getSelectionLength();
        this.offset = context.getSelectionOffset();
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        TextSelection selection = new TextSelection(this.offset, this.length);
        SemicolonRemover formatter = new SemicolonRemover((ITextSelection)selection, document);
        TextEdit textEdit = formatter.format();
        try {
            if (textEdit.getChildrenSize() > 0) {
                textEdit.apply(document);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Oops.", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset, 0);
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Remove unnecessary semicolons";
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getImage(), this.getDisplayString(), this.getDisplayString());
    }

    protected String getImageBundleLocation() {
        return "org.eclipse.jdt.ui.remove_correction.gif";
    }

    public boolean hasProposals() {
        return this.getContext().getCompilationUnit() instanceof GroovyCompilationUnit;
    }
}

