/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.quickassist.AbstractGroovyCompletionProposal;
import org.codehaus.groovy.eclipse.quickassist.StringConstantFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToSingleLineStringCompletionProposal
extends AbstractGroovyCompletionProposal {
    private final GroovyCompilationUnit unit;
    private final int length;
    private final int offset;
    private Expression literal;

    public ConvertToSingleLineStringCompletionProposal(IInvocationContext context) {
        super(context);
        ICompilationUnit compUnit = context.getCompilationUnit();
        this.unit = compUnit instanceof GroovyCompilationUnit ? (GroovyCompilationUnit)compUnit : null;
        this.length = context.getSelectionLength();
        this.offset = context.getSelectionOffset();
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        TextEdit thisEdit = this.findReplacement(document);
        try {
            if (thisEdit != null) {
                thisEdit.apply(document);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Oops.", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset, this.length + this.offset);
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Convert to single-line string";
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getImage(), this.getDisplayString(), this.getDisplayString());
    }

    protected String getImageBundleLocation() {
        return "org.eclipse.jdt.ui.correction_change.gif";
    }

    public boolean hasProposals() {
        if (this.unit == null) {
            return false;
        }
        boolean result = false;
        Region region = new Region(this.offset, this.length);
        StringConstantFinder finder = new StringConstantFinder(region);
        ModuleNode moduleNode = this.unit.getModuleNode();
        ASTNode node = finder.doVisit(moduleNode);
        if (node instanceof ConstantExpression && ((ConstantExpression)node).getValue() instanceof String || node instanceof GStringExpression) {
            Expression expr = (Expression)node;
            char[] contents = this.unit.getContents();
            int start = expr.getStart();
            int end = expr.getEnd();
            char[] nodeText = new char[end - start];
            if (end <= start) {
                return false;
            }
            System.arraycopy(contents, start, nodeText, 0, end - start);
            if (this.isMultiLineString(String.valueOf(nodeText))) {
                this.literal = expr;
                result = true;
            }
        }
        return result;
    }

    private TextEdit findReplacement(IDocument doc) {
        try {
            int startQuote = this.literal.getStart();
            int endQuote = this.literal.getEnd() - 3;
            return this.createEdit(doc, startQuote, endQuote);
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Exception during convert to single line string.", (Throwable)e);
            return null;
        }
    }

    private TextEdit createEdit(IDocument doc, int startQuote, int endQuote) throws BadLocationException {
        if (startQuote < 0 || startQuote + 3 >= doc.getLength() || endQuote < 0 || endQuote + 3 > doc.getLength()) {
            return null;
        }
        String startText = doc.get(startQuote, 3);
        String endText = doc.get(endQuote, 3);
        if (!startText.equals("\"\"\"") && !startText.equals("'''")) {
            return null;
        }
        if (!endText.equals("\"\"\"") && !endText.equals("'''")) {
            return null;
        }
        String replaceQuote = String.valueOf(startText.charAt(0));
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new ReplaceEdit(startQuote, 3, replaceQuote));
        edit.addChild((TextEdit)new ReplaceEdit(endQuote, 3, replaceQuote));
        boolean isSingle = replaceQuote.startsWith("'");
        int i = startQuote + 3;
        while (i < endQuote - 3) {
            char toEscape = doc.getChar(i);
            String escaped = null;
            switch (toEscape) {
                case '\t': {
                    escaped = "\\t";
                    break;
                }
                case '\b': {
                    escaped = "\\b";
                    break;
                }
                case '\n': {
                    escaped = "\\n";
                    break;
                }
                case '\r': {
                    escaped = "\\r";
                    break;
                }
                case '\f': {
                    escaped = "\\f";
                    break;
                }
                case '\'': {
                    if (!isSingle) break;
                    escaped = "\\'";
                    break;
                }
                case '\"': {
                    if (isSingle) break;
                    escaped = "\\\"";
                    break;
                }
                case '\\': {
                    escaped = "\\\\";
                }
            }
            if (escaped != null) {
                edit.addChild((TextEdit)new ReplaceEdit(i, 1, escaped));
            }
            ++i;
        }
        return edit;
    }

    private boolean isMultiLineString(String test) {
        return test.startsWith("'''") && test.endsWith("'''") || test.startsWith("\"\"\"") && test.endsWith("\"\"\"");
    }
}

