/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.quickassist.AbstractGroovyCompletionProposal;
import org.codehaus.groovy.eclipse.quickassist.StringConstantFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToMultiLineStringCompletionProposal
extends AbstractGroovyCompletionProposal {
    private final GroovyCompilationUnit unit;
    private final int length;
    private final int offset;
    private Expression literal;

    public ConvertToMultiLineStringCompletionProposal(IInvocationContext context) {
        super(context);
        ICompilationUnit compUnit = context.getCompilationUnit();
        this.unit = compUnit instanceof GroovyCompilationUnit ? (GroovyCompilationUnit)compUnit : null;
        this.length = context.getSelectionLength();
        this.offset = context.getSelectionOffset();
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        TextEdit thisEdit = this.findReplacement(document);
        try {
            if (thisEdit != null) {
                thisEdit.apply(document);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Oops.", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset, this.length + this.offset);
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Convert to multi-line string";
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getImage(), this.getDisplayString(), this.getDisplayString());
    }

    protected String getImageBundleLocation() {
        return "org.eclipse.jdt.ui.correction_change.gif";
    }

    public boolean hasProposals() {
        if (this.unit == null) {
            return false;
        }
        boolean result = false;
        Region region = new Region(this.offset, this.length);
        StringConstantFinder finder = new StringConstantFinder(region);
        ModuleNode moduleNode = this.unit.getModuleNode();
        ASTNode node = finder.doVisit(moduleNode);
        if (node instanceof ConstantExpression && ((ConstantExpression)node).getValue() instanceof String || node instanceof GStringExpression) {
            Expression expr = (Expression)node;
            char[] contents = this.unit.getContents();
            int start = expr.getStart();
            int end = expr.getEnd();
            char[] nodeText = new char[end - start];
            System.arraycopy(contents, start, nodeText, 0, end - start);
            if (this.isStringLiteral(nodeText) && !this.isMultiLineString(String.valueOf(nodeText))) {
                this.literal = expr;
                result = true;
            }
        }
        return result;
    }

    private boolean isStringLiteral(char[] nodeText) {
        return !(nodeText.length <= 1 || nodeText[0] != '\'' && nodeText[0] != '\"' || nodeText[nodeText.length - 1] != '\'' && nodeText[nodeText.length - 1] != '\"');
    }

    private TextEdit findReplacement(IDocument doc) {
        int endQuote;
        int startQuote;
        block3: {
            try {
                startQuote = this.literal.getStart();
                endQuote = this.literal.getEnd() - 1;
                if (startQuote < endQuote) break block3;
                return null;
            }
            catch (Exception e) {
                GroovyCore.logException((String)"Exception during convert to multiline string.", (Throwable)e);
                return null;
            }
        }
        return this.createEdit(doc, startQuote, endQuote);
    }

    private TextEdit createEdit(IDocument doc, int startQuote, int endQuote) throws BadLocationException {
        if (startQuote < 0 || startQuote >= doc.getLength() || endQuote < 0 || endQuote >= doc.getLength()) {
            return null;
        }
        if (doc.getChar(startQuote) != '\'' && doc.getChar(startQuote) != '\"') {
            return null;
        }
        if (doc.getChar(endQuote) != '\'' && doc.getChar(endQuote) != '\"') {
            return null;
        }
        char quoteChar = doc.getChar(startQuote);
        char skipChar = '\u0000';
        String replaceQuotes = new String(new char[]{quoteChar, quoteChar, quoteChar});
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new ReplaceEdit(startQuote, 1, replaceQuotes));
        edit.addChild((TextEdit)new ReplaceEdit(endQuote, 1, replaceQuotes));
        int i = startQuote + 1;
        while (i < endQuote - 1) {
            if (doc.getChar(i) == '\\' && doc.getChar(++i) != skipChar) {
                edit.addChild((TextEdit)new ReplaceEdit(i - 1, 2, this.unescaped(doc.getChar(i))));
            }
            ++i;
        }
        return edit;
    }

    private String unescaped(char escaped) {
        switch (escaped) {
            case 'u': {
                return "u";
            }
            case 't': {
                return "\t";
            }
            case 'b': {
                return "\b";
            }
            case 'n': {
                return "\n";
            }
            case 'r': {
                return "\r";
            }
            case 'f': {
                return "\n";
            }
            case '\'': {
                return "'";
            }
            case '\"': {
                return "\"";
            }
            case '\\': {
                return "\\";
            }
        }
        return String.valueOf(escaped);
    }

    private boolean isMultiLineString(String test) {
        return test.startsWith("'''") && test.endsWith("'''") || test.startsWith("\"\"\"") && test.endsWith("\"\"\"");
    }
}

