/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SQLType;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import microsoft.sql.DateTimeOffset;

public final class SQLServerCallableStatement
extends SQLServerPreparedStatement
implements ISQLServerCallableStatement {
    private ArrayList<String> paramNames;
    int nOutParams = 0;
    int nOutParamsAssigned = 0;
    private int outParamIndex = -1;
    private Parameter lastParamAccessed;
    private Closeable activeStream;

    @Override
    String getClassNameInternal() {
        return "SQLServerCallableStatement";
    }

    SQLServerCallableStatement(SQLServerConnection sQLServerConnection, String string, int n, int n2) throws SQLServerException {
        super(sQLServerConnection, string, n, n2);
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLServerException {
        Object object;
        Object object2;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        if (n < 1 || n > this.inOutParam.length) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            object = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), "7009", false);
        }
        if (2012 == n2) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_featureNotSupported"));
            object = new Object[]{new String("REF_CURSOR")};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), null, false);
        }
        object2 = JDBCType.of(n2);
        this.discardLastExecutionResults();
        if (((JDBCType)((Object)object2)).isUnsupported()) {
            object2 = JDBCType.BINARY;
        }
        object = this.inOutParam[n - 1];
        assert (null != object);
        if (!((Parameter)object).isOutput()) {
            ++this.nOutParams;
        }
        ((Parameter)object).registerForOutput((JDBCType)((Object)object2), this.connection);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(int n, SQLType sQLType) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), sQLType});
        }
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber());
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    private final Parameter getOutParameter(int n) throws SQLServerException {
        this.processResults();
        if (this.inOutParam[n - 1] == this.lastParamAccessed || this.inOutParam[n - 1].isValueGotten()) {
            return this.inOutParam[n - 1];
        }
        while (this.outParamIndex != n - 1) {
            this.skipOutParameters(1, false);
        }
        return this.inOutParam[n - 1];
    }

    @Override
    void startResults() {
        super.startResults();
        this.outParamIndex = -1;
        this.nOutParamsAssigned = 0;
        this.lastParamAccessed = null;
        assert (null == this.activeStream);
    }

    @Override
    void processBatch() throws SQLServerException {
        this.processResults();
        assert (this.nOutParams >= 0);
        if (this.nOutParams > 0) {
            this.processOutParameters();
            this.processBatchRemainder();
        }
    }

    final void processOutParameters() throws SQLServerException {
        assert (this.nOutParams > 0);
        assert (null != this.inOutParam);
        this.closeActiveStream();
        if (this.outParamIndex >= 0) {
            for (int i = 0; i < this.inOutParam.length; ++i) {
                if (i == this.outParamIndex || !this.inOutParam[i].isValueGotten()) continue;
                assert (this.inOutParam[i].isOutput());
                this.inOutParam[i].resetOutputValue();
            }
        }
        assert (this.nOutParamsAssigned <= this.nOutParams);
        if (this.nOutParamsAssigned < this.nOutParams) {
            this.skipOutParameters(this.nOutParams - this.nOutParamsAssigned, true);
        }
        if (this.outParamIndex >= 0) {
            this.inOutParam[this.outParamIndex].skipValue(this.resultsReader(), true);
            this.inOutParam[this.outParamIndex].resetOutputValue();
            this.outParamIndex = -1;
        }
    }

    private void processBatchRemainder() throws SQLServerException {
        final class ExecDoneHandler
        extends TDSTokenHandler {
            ExecDoneHandler() {
                super("ExecDoneHandler");
            }

            @Override
            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (streamDone.wasRPCInBatch()) {
                    SQLServerCallableStatement.this.startResults();
                    return false;
                }
                return true;
            }
        }
        ExecDoneHandler execDoneHandler = new ExecDoneHandler();
        TDSParser.parse(this.resultsReader(), execDoneHandler);
    }

    private void skipOutParameters(int n, boolean bl) throws SQLServerException {
        final class OutParamHandler
        extends TDSTokenHandler {
            final StreamRetValue srv;
            private boolean foundParam;

            final boolean foundParam() {
                return this.foundParam;
            }

            OutParamHandler() {
                super("OutParamHandler");
                this.srv = new StreamRetValue();
            }

            final void reset() {
                this.foundParam = false;
            }

            @Override
            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                this.srv.setFromTDS(tDSReader);
                this.foundParam = true;
                return false;
            }
        }
        OutParamHandler outParamHandler = new OutParamHandler();
        assert (n <= this.nOutParams - this.nOutParamsAssigned);
        for (int i = 0; i < n; ++i) {
            if (-1 != this.outParamIndex) {
                this.inOutParam[this.outParamIndex].skipValue(this.resultsReader(), bl);
                if (bl) {
                    this.inOutParam[this.outParamIndex].resetOutputValue();
                }
            }
            outParamHandler.reset();
            TDSParser.parse(this.resultsReader(), outParamHandler);
            if (!outParamHandler.foundParam()) {
                if (bl) break;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(this.outParamIndex + 1)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            this.outParamIndex = outParamHandler.srv.getOrdinalOrLength();
            this.outParamIndex -= this.outParamIndexAdjustment;
            if (this.outParamIndex < 0 || this.outParamIndex >= this.inOutParam.length || !this.inOutParam[this.outParamIndex].isOutput()) {
                this.getStatementLogger().info(this.toString() + " Unexpected outParamIndex: " + this.outParamIndex + "; adjustment: " + this.outParamIndexAdjustment);
                this.connection.throwInvalidTDS();
            }
            ++this.nOutParamsAssigned;
        }
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), new Integer(n2), string});
        }
        this.checkClosed();
        this.registerOutParameter(n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(int n, SQLType sQLType, String string) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), sQLType, string});
        }
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber(), string);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), new Integer(n2), new Integer(n3)});
        }
        this.checkClosed();
        this.registerOutParameter(n, n2);
        this.inOutParam[n - 1].setOutScale(n3);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(int n, SQLType sQLType, int n2) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{new Integer(n), sQLType, new Integer(n2)});
        }
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber(), n2);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    private Parameter getterGetParam(int n) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        this.checkClosed();
        if (n < 1 || n > this.inOutParam.length) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidOutputParameter"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        if (!this.inOutParam[n - 1].isOutput()) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_outputParameterNotRegisteredForOutput"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", true);
        }
        if (!this.wasExecuted()) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), "07009", false);
        }
        this.resultsReader().getCommand().checkForInterrupt();
        this.closeActiveStream();
        if (this.getStatementLogger().isLoggable(Level.FINER)) {
            this.getStatementLogger().finer(this.toString() + " Getting Param:" + n);
        }
        this.lastParamAccessed = this.getOutParameter(n);
        return this.lastParamAccessed;
    }

    private Object getValue(int n, JDBCType jDBCType) throws SQLServerException {
        return this.getterGetParam(n).getValue(jDBCType, null, null, this.resultsReader());
    }

    private Object getValue(int n, JDBCType jDBCType, Calendar calendar) throws SQLServerException {
        return this.getterGetParam(n).getValue(jDBCType, null, calendar, this.resultsReader());
    }

    private Object getStream(int n, StreamType streamType) throws SQLServerException {
        Object object = this.getterGetParam(n).getValue(streamType.getJDBCType(), new InputStreamGetterArgs(streamType, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toString()), null, this.resultsReader());
        this.activeStream = (Closeable)object;
        return object;
    }

    private Object getSQLXMLInternal(int n) throws SQLServerException {
        SQLServerSQLXML sQLServerSQLXML = (SQLServerSQLXML)this.getterGetParam(n).getValue(JDBCType.SQLXML, new InputStreamGetterArgs(StreamType.SQLXML, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toString()), null, this.resultsReader());
        if (null != sQLServerSQLXML) {
            this.activeStream = sQLServerSQLXML.getStream();
        }
        return sQLServerSQLXML;
    }

    @Override
    public int getInt(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", n);
        this.checkClosed();
        Integer n2 = (Integer)this.getValue(n, JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", n2);
        return null != n2 ? n2 : 0;
    }

    @Override
    public int getInt(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", string);
        this.checkClosed();
        Integer n = (Integer)this.getValue(this.findColumn(string), JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", n);
        return null != n ? n : 0;
    }

    @Override
    public String getString(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", n);
        this.checkClosed();
        String string = (String)this.getValue(n, JDBCType.CHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getString", string);
        return string;
    }

    @Override
    public String getString(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", string);
        this.checkClosed();
        String string2 = (String)this.getValue(this.findColumn(string), JDBCType.CHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getString", string2);
        return string2;
    }

    @Override
    public final String getNString(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNString", n);
        this.checkClosed();
        String string = (String)this.getValue(n, JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", string);
        return string;
    }

    @Override
    public final String getNString(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNString", string);
        this.checkClosed();
        String string2 = (String)this.getValue(this.findColumn(string), JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", string2);
        return string2;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", new Object[]{n, n2});
        }
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(n, JDBCType.DECIMAL);
        if (null != bigDecimal) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", new Object[]{string, n});
        }
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(this.findColumn(string), JDBCType.DECIMAL);
        if (null != bigDecimal) {
            bigDecimal = bigDecimal.setScale(n, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    public boolean getBoolean(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", n);
        this.checkClosed();
        Boolean bl = (Boolean)this.getValue(n, JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", bl);
        return null != bl ? bl : false;
    }

    @Override
    public boolean getBoolean(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", string);
        this.checkClosed();
        Boolean bl = (Boolean)this.getValue(this.findColumn(string), JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", bl);
        return null != bl ? bl : false;
    }

    @Override
    public byte getByte(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", n);
        this.checkClosed();
        Short s = (Short)this.getValue(n, JDBCType.TINYINT);
        byte by = null != s ? s.byteValue() : (byte)0;
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", by);
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", string);
        this.checkClosed();
        Short s = (Short)this.getValue(this.findColumn(string), JDBCType.TINYINT);
        byte by = null != s ? s.byteValue() : (byte)0;
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", by);
        return by;
    }

    @Override
    public byte[] getBytes(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", n);
        this.checkClosed();
        byte[] byArray = (byte[])this.getValue(n, JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", byArray);
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", string);
        this.checkClosed();
        byte[] byArray = (byte[])this.getValue(this.findColumn(string), JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", byArray);
        return byArray;
    }

    @Override
    public Date getDate(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", n);
        this.checkClosed();
        Date date = (Date)this.getValue(n, JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", string);
        this.checkClosed();
        Date date = (Date)this.getValue(this.findColumn(string), JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{n, calendar});
        }
        this.checkClosed();
        Date date = (Date)this.getValue(n, JDBCType.DATE, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{string, calendar});
        }
        this.checkClosed();
        Date date = (Date)this.getValue(this.findColumn(string), JDBCType.DATE, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public double getDouble(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", n);
        this.checkClosed();
        Double d = (Double)this.getValue(n, JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", d);
        return null != d ? d : 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", string);
        this.checkClosed();
        Double d = (Double)this.getValue(this.findColumn(string), JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", d);
        return null != d ? d : 0.0;
    }

    @Override
    public float getFloat(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", n);
        this.checkClosed();
        Float f = (Float)this.getValue(n, JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", f);
        return null != f ? f.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", string);
        this.checkClosed();
        Float f = (Float)this.getValue(this.findColumn(string), JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", f);
        return null != f ? f.floatValue() : 0.0f;
    }

    @Override
    public long getLong(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", n);
        this.checkClosed();
        Long l = (Long)this.getValue(n, JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", l);
        return null != l ? l : 0L;
    }

    @Override
    public long getLong(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", string);
        this.checkClosed();
        Long l = (Long)this.getValue(this.findColumn(string), JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", l);
        return null != l ? l : 0L;
    }

    @Override
    public Object getObject(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", n);
        this.checkClosed();
        Object object = this.getValue(n, this.getterGetParam(n).getJdbcType());
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", object);
        return object;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public Object getObject(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", string);
        this.checkClosed();
        int n = this.findColumn(string);
        Object object = this.getValue(n, this.getterGetParam(n).getJdbcType());
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", object);
        return object;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public short getShort(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", n);
        this.checkClosed();
        Short s = (Short)this.getValue(n, JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", s);
        return null != s ? s : (short)0;
    }

    @Override
    public short getShort(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", string);
        this.checkClosed();
        Short s = (Short)this.getValue(this.findColumn(string), JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", s);
        return null != s ? s : (short)0;
    }

    @Override
    public Time getTime(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", n);
        this.checkClosed();
        Time time = (Time)this.getValue(n, JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", string);
        this.checkClosed();
        Time time = (Time)this.getValue(this.findColumn(string), JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{n, calendar});
        }
        this.checkClosed();
        Time time = (Time)this.getValue(n, JDBCType.TIME, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{string, calendar});
        }
        this.checkClosed();
        Time time = (Time)this.getValue(this.findColumn(string), JDBCType.TIME, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", n);
        }
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(n, JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", string);
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(this.findColumn(string), JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{n, calendar});
        }
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(n, JDBCType.TIMESTAMP, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{string, calendar});
        }
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(this.findColumn(string), JDBCType.TIMESTAMP, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", n);
        }
        this.checkClosed();
        if (!this.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset dateTimeOffset = (DateTimeOffset)this.getValue(n, JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", dateTimeOffset);
        return dateTimeOffset;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(String string) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", string);
        this.checkClosed();
        if (!this.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset dateTimeOffset = (DateTimeOffset)this.getValue(this.findColumn(string), JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", dateTimeOffset);
        return dateTimeOffset;
    }

    @Override
    public boolean wasNull() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "wasNull");
        this.checkClosed();
        boolean bl = false;
        if (null != this.lastParamAccessed) {
            bl = this.lastParamAccessed.isNull();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "wasNull", bl);
        return bl;
    }

    public final InputStream getAsciiStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", n);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(n, StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", inputStream);
        return inputStream;
    }

    public final InputStream getAsciiStream(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", string);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(this.findColumn(string), StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", inputStream);
        return inputStream;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", n);
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(n, JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", string);
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(this.findColumn(string), JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    public final InputStream getBinaryStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", n);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(n, StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", inputStream);
        return inputStream;
    }

    public final InputStream getBinaryStream(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", string);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(this.findColumn(string), StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", inputStream);
        return inputStream;
    }

    @Override
    public Blob getBlob(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", n);
        this.checkClosed();
        Blob blob = (Blob)this.getValue(n, JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", blob);
        return blob;
    }

    @Override
    public Blob getBlob(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", string);
        this.checkClosed();
        Blob blob = (Blob)this.getValue(this.findColumn(string), JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", blob);
        return blob;
    }

    @Override
    public final Reader getCharacterStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", n);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(n, StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterStream", reader);
        return reader;
    }

    @Override
    public final Reader getCharacterStream(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", string);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(this.findColumn(string), StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterSream", reader);
        return reader;
    }

    @Override
    public final Reader getNCharacterStream(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", n);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(n, StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    @Override
    public final Reader getNCharacterStream(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", string);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(this.findColumn(string), StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActiveStream() throws SQLServerException {
        if (null != this.activeStream) {
            try {
                this.activeStream.close();
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
    }

    @Override
    public Clob getClob(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", n);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(n, JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public Clob getClob(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", string);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(this.findColumn(string), JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", n);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(n, JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", string);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(this.findColumn(string), JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLServerException {
        this.checkClosed();
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLServerException {
        this.checkClosed();
        return this.getArray(this.findColumn(string));
    }

    private int findColumn(String string) throws SQLServerException {
        Object object;
        Object object2;
        if (this.paramNames == null) {
            try {
                SQLServerStatement sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                final class ThreePartNamesParser {
                    private String procedurePart = null;
                    private String ownerPart = null;
                    private String databasePart = null;
                    private final Pattern threePartName = Pattern.compile(JDBCSyntaxTranslator.getSQLIdentifierWithGroups());

                    ThreePartNamesParser() {
                    }

                    String getProcedurePart() {
                        return this.procedurePart;
                    }

                    String getOwnerPart() {
                        return this.ownerPart;
                    }

                    String getDatabasePart() {
                        return this.databasePart;
                    }

                    final void parseProcedureNameIntoParts(String string) {
                        if (null != string) {
                            Matcher matcher = this.threePartName.matcher(string);
                            if (matcher.matches()) {
                                if (matcher.group(2) != null) {
                                    this.databasePart = matcher.group(1);
                                    if ((matcher = this.threePartName.matcher(matcher.group(2))).matches()) {
                                        if (null != matcher.group(2)) {
                                            this.ownerPart = matcher.group(1);
                                            this.procedurePart = matcher.group(2);
                                        } else {
                                            this.ownerPart = this.databasePart;
                                            this.databasePart = null;
                                            this.procedurePart = matcher.group(1);
                                        }
                                    }
                                } else {
                                    this.procedurePart = matcher.group(1);
                                }
                            } else {
                                this.procedurePart = string;
                            }
                        }
                    }
                }
                ThreePartNamesParser threePartNamesParser = new ThreePartNamesParser();
                threePartNamesParser.parseProcedureNameIntoParts(this.procedureName);
                StringBuilder stringBuilder = new StringBuilder("exec sp_sproc_columns ");
                if (null != threePartNamesParser.getDatabasePart()) {
                    stringBuilder.append("@procedure_qualifier=");
                    stringBuilder.append(threePartNamesParser.getDatabasePart());
                    stringBuilder.append(", ");
                }
                if (null != threePartNamesParser.getOwnerPart()) {
                    stringBuilder.append("@procedure_owner=");
                    stringBuilder.append(threePartNamesParser.getOwnerPart());
                    stringBuilder.append(", ");
                }
                if (null != threePartNamesParser.getProcedurePart()) {
                    stringBuilder.append("@procedure_name=");
                    stringBuilder.append(threePartNamesParser.getProcedurePart());
                    stringBuilder.append(" , @ODBCVer=3");
                } else {
                    object2 = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
                    object = new Object[]{string, ""};
                    SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), "07009", false);
                }
                object2 = sQLServerStatement.executeQueryInternal(stringBuilder.toString());
                this.paramNames = new ArrayList();
                while (object2.next()) {
                    object = object2.getString(4);
                    this.paramNames.add(((String)object).trim());
                }
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.connection, this, sQLException.toString(), null, false);
            }
        }
        int n = 0;
        if (this.paramNames != null) {
            n = this.paramNames.size();
        }
        int n2 = 0;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            object2 = this.paramNames.get(n2);
            if (!((String)(object2 = ((String)object2).substring(1, ((String)object2).length()))).equals(string)) continue;
            n3 = n2;
            break;
        }
        if (-1 == n3) {
            for (n2 = 0; n2 < n; ++n2) {
                object2 = this.paramNames.get(n2);
                if (!((String)(object2 = ((String)object2).substring(1, ((String)object2).length()))).equalsIgnoreCase(string)) continue;
                n3 = n2;
                break;
            }
        }
        if (-1 == n3) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
            object = new Object[]{string, this.procedureName};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), "07009", false);
        }
        if (this.bReturnValueSyntax) {
            return n3 + 1;
        }
        return n3;
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimeStamp", new Object[]{string, timestamp, calendar});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.TIMESTAMP, timestamp, JavaType.TIMESTAMP, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimeStamp");
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{string, time, calendar});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.TIME, time, JavaType.TIME, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{string, date, calendar});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.DATE, date, JavaType.DATE, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{string, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{string, reader, n});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, n);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setNCharacterStream(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{string, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setClob(String string, Clob clob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{string, clob});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.CLOB, clob, JavaType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{string, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setNClob(String string, NClob nClob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{string, nClob});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.NCLOB, nClob, JavaType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{string, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNString(String string, String string2) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{string, string2});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.NVARCHAR, string2, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    @Override
    public void setObject(String string, Object object) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{string, object});
        }
        this.checkClosed();
        this.setObjectNoType(this.findColumn(string), object);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{string, object, n});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(string)), object, JavaType.of(object), JDBCType.of(n), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public void setObject(String string, Object object, SQLType sQLType) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{string, object, sQLType});
        }
        this.setObject(string, object, (int)sQLType.getVendorTypeNumber());
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{string, object, n, n2});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(string)), object, JavaType.of(object), JDBCType.of(n), 2 == n || 3 == n ? Integer.valueOf(n2) : null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public void setObject(String string, Object object, SQLType sQLType, int n) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{string, object, sQLType, n});
        }
        this.setObject(string, object, (int)sQLType.getVendorTypeNumber(), n);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{string, inputStream});
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{string, inputStream, n});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, n);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{string, inputStream, l});
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{string, inputStream});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{string, inputStream, n});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, n);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{string, inputStream, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBlob(String string, Blob blob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{string, blob});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.BLOB, blob, JavaType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(String string, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{string, inputStream});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{string, inputStream, l});
        }
        this.checkClosed();
        this.setStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{string, timestamp});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.TIMESTAMP, timestamp, JavaType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public void setDateTimeOffset(String string, DateTimeOffset dateTimeOffset) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{string, dateTimeOffset});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.DATETIMEOFFSET, dateTimeOffset, JavaType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    @Override
    public void setDate(String string, Date date) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{string, date});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.DATE, date, JavaType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public void setTime(String string, Time time) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{string, time});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.TIME, time, JavaType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{string, byArray});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.BINARY, byArray, JavaType.BYTEARRAY);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    @Override
    public void setByte(String string, byte by) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{string, by});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.TINYINT, by, JavaType.BYTE);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    @Override
    public void setString(String string, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{string, string2});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.VARCHAR, string2, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{string, bigDecimal});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.DECIMAL, bigDecimal, JavaType.BIGDECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    @Override
    public void setDouble(String string, double d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{string, d});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.DOUBLE, d, JavaType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    @Override
    public void setFloat(String string, float f) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{string, Float.valueOf(f)});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.REAL, Float.valueOf(f), JavaType.FLOAT);
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    @Override
    public void setInt(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{string, n});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.INTEGER, n, JavaType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    @Override
    public void setLong(String string, long l) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{string, l});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.BIGINT, l, JavaType.LONG);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    @Override
    public void setShort(String string, short s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{string, s});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.SMALLINT, s, JavaType.SHORT);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{string, bl});
        }
        this.checkClosed();
        this.setValue(this.findColumn(string), JDBCType.BIT, bl, JavaType.BOOLEAN);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    @Override
    public void setNull(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{string, n});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(string)), null, JavaType.OBJECT, JDBCType.of(n), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{string, n, string2});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(string)), null, JavaType.OBJECT, JDBCType.of(n), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setURL", string);
        this.checkClosed();
        this.setURL(this.findColumn(string), uRL);
        loggerExternal.exiting(this.getClassNameLogging(), "setURL");
    }

    @Override
    public URL getURL(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public final void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSQLXML", new Object[]{string, sQLXML});
        }
        this.checkClosed();
        this.setSQLXMLInternal(this.findColumn(string), sQLXML);
        loggerExternal.exiting(this.getClassNameLogging(), "setSQLXML");
    }

    @Override
    public final SQLXML getSQLXML(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", n);
        this.checkClosed();
        SQLServerSQLXML sQLServerSQLXML = (SQLServerSQLXML)this.getSQLXMLInternal(n);
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", sQLServerSQLXML);
        return sQLServerSQLXML;
    }

    @Override
    public final SQLXML getSQLXML(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", string);
        this.checkClosed();
        SQLServerSQLXML sQLServerSQLXML = (SQLServerSQLXML)this.getSQLXMLInternal(this.findColumn(string));
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", sQLServerSQLXML);
        return sQLServerSQLXML;
    }

    @Override
    public final void setRowId(String string, RowId rowId) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final RowId getRowId(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final RowId getRowId(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, new Integer(n), string2});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, string2);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(String string, SQLType sQLType, String string2) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, sQLType, string2});
        }
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber(), string2);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(String string, SQLType sQLType, int n) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, sQLType, new Integer(n)});
        }
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber(), n);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, new Integer(n)});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(String string, SQLType sQLType) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{string, sQLType});
        }
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber());
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }
}

