/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;

public class ImportNodeCompatibilityWrapper {
    private ModuleNode module;
    private List<ImportNode> sortedImports;

    public ImportNodeCompatibilityWrapper(ModuleNode module) {
        if (module == null) {
            throw new IllegalArgumentException("Module node should not be null");
        }
        this.module = module;
    }

    public List<ImportNode> getAllImportNodes() {
        if (this.sortedImports == null) {
            this.sortedImports = new ArrayList<ImportNode>();
            this.sortedImports.addAll(this.module.getImports());
            this.sortedImports.addAll(this.module.getStarImports());
            this.sortedImports.addAll(this.module.getStaticImports().values());
            this.sortedImports.addAll(this.module.getStaticStarImports().values());
            Collections.sort(this.sortedImports, new ImportNodeComparator());
            this.sortedImports = Collections.unmodifiableList(this.sortedImports);
        }
        return this.sortedImports;
    }

    public static String getFieldName(ImportNode node) {
        return node.getFieldName();
    }

    public static Map<String, ImportNode> getStaticImports(ModuleNode node) {
        return node.getStaticImports();
    }

    public static Map<String, ImportNode> getStaticStarImports(ModuleNode node) {
        return node.getStaticStarImports();
    }

    public static List<ImportNode> getStarImports(ModuleNode node) {
        return node.getStarImports();
    }

    private class ImportNodeComparator
    implements Comparator<ImportNode> {
        private ImportNodeComparator() {
        }

        @Override
        public int compare(ImportNode i1, ImportNode i2) {
            int start2;
            int start1 = i1.getStart();
            if (start1 <= 0 && i1.getType() != null) {
                start1 = i1.getType().getStart();
            }
            if ((start2 = i2.getStart()) <= 0 && i2.getType() != null) {
                start2 = i2.getType().getStart();
            }
            return start1 - start2;
        }
    }
}

