/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.SyntaxException;

public abstract class ClassCodeVisitorSupport
extends CodeVisitorSupport
implements GroovyClassVisitor {
    public static final String ORIGINAL_EXPRESSION = "OriginalExpression";

    public void visitClass(ClassNode node) {
        this.visitAnnotations(node);
        this.visitPackage(node.getPackage());
        this.visitImports(node.getModule());
        node.visitContents(this);
        this.visitObjectInitializerStatements(node);
    }

    protected void visitObjectInitializerStatements(ClassNode node) {
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.visitAnnotations((AnnotatedNode)node);
            node.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitImports(ModuleNode node) {
        if (node != null) {
            for (ImportNode importNode : node.getImports()) {
                this.visitAnnotations(importNode);
                importNode.visit(this);
            }
            for (ImportNode importStarNode : node.getStarImports()) {
                this.visitAnnotations(importStarNode);
                importStarNode.visit(this);
            }
            for (ImportNode importStaticNode : node.getStaticImports().values()) {
                this.visitAnnotations(importStaticNode);
                importStaticNode.visit(this);
            }
            for (ImportNode importStaticStarNode : node.getStaticStarImports().values()) {
                this.visitAnnotations(importStaticStarNode);
                importStaticStarNode.visit(this);
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        List<AnnotationNode> annotations = node.getAnnotations();
        if (!annotations.isEmpty()) {
            this.visitAnnotations(annotations);
        }
    }

    protected void visitAnnotations(Iterable<AnnotationNode> nodes) {
        for (AnnotationNode node : nodes) {
            if (node.isBuiltIn()) continue;
            Set originals = (Set)node.getNodeMetaData("AnnotationCollector");
            if (originals != null && !originals.isEmpty()) {
                this.visitAnnotations(originals);
            }
            this.visitAnnotation(node);
        }
    }

    protected void visitAnnotation(AnnotationNode node) {
        for (Expression expr : node.getMembers().values()) {
            expr.visit((GroovyCodeVisitor)this);
        }
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        Expression original = (Expression)expression.getNodeMetaData((Object)ORIGINAL_EXPRESSION);
        if (original != null) {
            original.visit((GroovyCodeVisitor)this);
        }
    }

    public static final Expression getNonInlinedExpression(Expression expression) {
        Expression original = (Expression)expression.getNodeMetaData((Object)ORIGINAL_EXPRESSION);
        return original != null ? original : expression;
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit((GroovyCodeVisitor)this);
        }
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitAnnotations((AnnotatedNode)expression);
        super.visitDeclarationExpression(expression);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations(node);
        this.visitClassCodeContainer(node.getCode());
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            this.visitAnnotations(param);
            ++n2;
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitConstructorOrMethod((MethodNode)node, true);
    }

    public void visitMethod(MethodNode node) {
        this.visitConstructorOrMethod(node, false);
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        Expression init = node.getInitialExpression();
        if (init != null) {
            init.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitProperty(PropertyNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        Statement statement = node.getGetterBlock();
        this.visitClassCodeContainer(statement);
        statement = node.getSetterBlock();
        this.visitClassCodeContainer(statement);
        Expression init = node.getInitialExpression();
        if (init != null) {
            init.visit((GroovyCodeVisitor)this);
        }
    }

    protected void addError(String msg, ASTNode expr) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        int start = expr.getStart();
        int end = expr.getEnd() - 1;
        if (expr instanceof ClassNode) {
            ClassNode cn = (ClassNode)expr;
            if (cn.getNameEnd() > 0) {
                start = cn.getNameStart();
                end = cn.getNameEnd();
            } else if (cn.getComponentType() != null) {
                --end;
            }
        } else if (expr instanceof DeclarationExpression) {
            DeclarationExpression decl = (DeclarationExpression)expr;
            Expression lhs = decl.getLeftExpression();
            start = lhs.getStart();
            end = lhs instanceof VariableExpression ? start + lhs.getText().length() - 1 : lhs.getEnd() - 1;
        }
        SourceUnit source = this.getSourceUnit();
        source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage((SyntaxException)new PreciseSyntaxException(String.valueOf(msg) + '\n', line, col, start, end), source));
    }

    protected void addTypeError(String msg, ClassNode expr) {
        SourceUnit source = this.getSourceUnit();
        source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage((SyntaxException)new PreciseSyntaxException(String.valueOf(msg) + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getNameStart(), expr.getNameEnd()), source));
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    protected void visitStatement(Statement statement) {
    }

    @Override
    public void visitAssertStatement(AssertStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitAssertStatement(statement);
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        this.visitStatement((Statement)block);
        super.visitBlockStatement(block);
    }

    @Override
    public void visitBreakStatement(BreakStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitBreakStatement(statement);
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitCaseStatement(statement);
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitCatchStatement(statement);
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitContinueStatement(statement);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.visitStatement((Statement)loop);
        super.visitDoWhileLoop(loop);
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitExpressionStatement(statement);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.visitStatement((Statement)forLoop);
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        this.visitStatement((Statement)ifElse);
        super.visitIfElse(ifElse);
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitReturnStatement(statement);
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitSwitch(statement);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitSynchronizedStatement(statement);
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitThrowStatement(statement);
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitTryCatchFinally(statement);
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        this.visitStatement((Statement)loop);
        super.visitWhileLoop(loop);
    }
}

