/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.util.collections.NameValuePair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.CharArrayBuffer;

public class URLBuilder {
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final char NAME_VALUE_SEPARATOR = '=';
    private String path;
    private List<NameValuePair> queryParams;
    private String query;
    private String ref;

    public URLBuilder() {
    }

    public URLBuilder(String string) {
        this.digestURL(string);
    }

    private void digestURL(String string) {
        String url = string;
        int ind = url.indexOf(35);
        this.ref = ind < 0 ? null : url.substring(ind + 1);
        url = ind < 0 ? url : url.substring(0, ind);
        int q = url.lastIndexOf(63);
        if (q != -1) {
            this.query = url.substring(q + 1);
            this.path = url.substring(0, q);
        } else {
            this.path = url;
        }
        if (!StringUtils.isBlank((CharSequence)this.query)) {
            this.queryParams = this.parseQuery(this.query);
        }
    }

    private List<NameValuePair> parseQuery(String query) {
        if (!StringUtils.isBlank((CharSequence)query)) {
            CharArrayBuffer buffer = new CharArrayBuffer(query.length());
            buffer.append(query);
            return this.parse(buffer, '&', ';');
        }
        return this.queryParams;
    }

    private List<NameValuePair> parse(CharArrayBuffer buf, char ... separators) {
        TokenParser tokenParser = TokenParser.INSTANCE;
        BitSet delimSet = new BitSet();
        char[] cArray = separators;
        int n = separators.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            delimSet.set(separator);
            ++n2;
        }
        ParserCursor cursor = new ParserCursor(0, buf.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            delimSet.set(61);
            String name = tokenParser.parseToken(buf, cursor, delimSet);
            String value = null;
            if (!cursor.atEnd()) {
                char delim = buf.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (delim == '=') {
                    delimSet.clear(61);
                    value = tokenParser.parseValue(buf, cursor, delimSet);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            list.add(new NameValuePair(name, value));
        }
        return list;
    }

    public URLBuilder setParameters(List<NameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        this.queryParams.addAll(nvps);
        this.query = null;
        return this;
    }

    public URLBuilder addParameters(List<NameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        this.queryParams.addAll(nvps);
        this.query = null;
        return this;
    }

    public List<NameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<NameValuePair>(this.queryParams);
        }
        return new ArrayList<NameValuePair>();
    }

    public String buildString() {
        StringBuilder sb = new StringBuilder();
        if (this.path != null) {
            sb.append(this.path);
        }
        if (this.query != null) {
            sb.append("?").append(this.query);
        } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("?").append(this.toQueryString(this.queryParams));
        }
        if (this.ref != null) {
            sb.append("#").append(this.ref);
        }
        return sb.toString();
    }

    private String toQueryString(List<NameValuePair> queryParams) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair parameter : queryParams) {
            String name = parameter.getName();
            String value = parameter.getValue();
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(name);
            if (value == null) continue;
            result.append('=');
            result.append(value);
        }
        return result.toString();
    }
}

