/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SystemInformationUtil {
    private OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private static int ONE_MB = 0x100000;
    private static int ONE_KB = 1024;

    public SystemInformationUtil() {
        try {
            SystemInformationUtil.getProcessCpuLoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getProcessCpuLoad() throws MalformedObjectNameException, ReflectionException, InstanceNotFoundException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
        AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
        if (list.isEmpty()) {
            return 0.0;
        }
        Attribute att = (Attribute)list.get(0);
        Double value = (Double)att.getValue();
        if (value < 0.0) {
            return 0.0;
        }
        return value * 100.0;
    }

    public static long totalPhysicalMemorySize() throws InstanceNotFoundException, AttributeNotFoundException, MalformedObjectNameException, ReflectionException, MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        long totalMemory = Long.parseLong(attribute.toString()) / (long)ONE_KB;
        return totalMemory;
    }

    public static long freePhysicalMemorySize() throws InstanceNotFoundException, AttributeNotFoundException, MalformedObjectNameException, ReflectionException, MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Object attribute2 = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "FreePhysicalMemorySize");
        long freeMemory = Long.parseLong(attribute2.toString()) / (long)ONE_KB;
        return freeMemory;
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory() / (long)ONE_MB;
    }

    public static long getUsedMemory() {
        return SystemInformationUtil.getMaxMemory() - SystemInformationUtil.getFreeMemory() / (long)ONE_MB;
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / (long)ONE_MB;
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / (long)ONE_MB;
    }

    public static double getPercentageUsed() {
        return (double)SystemInformationUtil.getUsedMemory() / (double)SystemInformationUtil.getMaxMemory() * 100.0;
    }

    public static double getPercentageUsedFormatted() {
        double usedPercentage = SystemInformationUtil.getPercentageUsed();
        return usedPercentage;
    }
}

