/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;

public class NetworkUtil {
    private static final List<NetworkInterface> NETWORK_INTERFACES = NetworkUtil.collectNetworkInterface();

    private static List<NetworkInterface> collectNetworkInterface() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException socketException) {
            return new ArrayList<NetworkInterface>();
        }
    }

    public static String getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String getFirstLocalNonLoopbackIpAddress() throws SocketException {
        TreeSet<String> addresses = new TreeSet<String>();
        for (NetworkInterface ni : NETWORK_INTERFACES) {
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                addresses.add(address.getHostAddress());
            }
        }
        if (addresses.isEmpty()) {
            throw new SocketException("Failed to get non-loopback IP address!");
        }
        return (String)addresses.first();
    }

    public static String getMacAddress(String ipAddress) throws SocketException {
        for (NetworkInterface ni : NETWORK_INTERFACES) {
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (!address.getHostAddress().equalsIgnoreCase(ipAddress) || ni.getHardwareAddress() == null) continue;
                byte[] macAddress = ni.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                int index = 0;
                while (index < macAddress.length - 1) {
                    sb.append(String.format("%02X:", macAddress[index]));
                    ++index;
                }
                sb.append(String.format("%02X", macAddress[macAddress.length - 1]));
                return sb.toString();
            }
        }
        return null;
    }
}

