/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view.contribution;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.search.constants.StringConstants;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class SearchMenuContribution {
    private static final String SHOW_REFERENCES_POPUP_MENUITEM_LABEL = StringConstants.CONTR_MENU_CONTEXT_SHOW_REFERENCES;
    public static final String SHOW_REFERENCES_COMMAND_ID = "com.kms.katalon.composer.search.command.showReferences";
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (selection == null) {
                    return;
                }
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    SearchMenuContribution.this.selectionService.setSelection(selection);
                }
            }
        });
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            MHandledMenuItem newFolderPopupMenuItem;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (this.canExecute(selectedObjects) && (newFolderPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(SHOW_REFERENCES_COMMAND_ID, null), (String)SHOW_REFERENCES_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI())) != null) {
                menuItems.add((MMenuElement)newFolderPopupMenuItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    private boolean canExecute(Object[] selectedObjects) throws Exception {
        if (selectedObjects == null || selectedObjects.length != 1) {
            return false;
        }
        ITreeEntity treeEntity = (ITreeEntity)selectedObjects[0];
        if (treeEntity instanceof TestCaseTreeEntity || treeEntity instanceof WebElementTreeEntity || treeEntity instanceof TestDataTreeEntity || treeEntity instanceof KeywordTreeEntity || treeEntity instanceof PackageTreeEntity) {
            return true;
        }
        if (treeEntity instanceof FolderTreeEntity) {
            FolderEntity folder = (FolderEntity)treeEntity.getObject();
            if (folder == null) {
                return false;
            }
            switch (folder.getFolderType()) {
                case DATAFILE: {
                    return true;
                }
                case KEYWORD: {
                    return true;
                }
                case TESTCASE: {
                    return true;
                }
                case WEBELEMENT: {
                    return true;
                }
            }
        }
        return false;
    }
}

